/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.SPLParseError;
import com.splunk.commons.ast.SPLParseErrorType;
import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.SPLParseResult;
import com.splunk.commons.ast.antlr.CompleteSPLParser;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.datasets.CachedResolverWrapper;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.visitors.DatasetsQualifierVisitor;
import com.splunk.commons.visitors.Expander;
import com.splunk.commons.visitors.JsonFormatter;
import com.splunk.commons.visitors.ReferencedDatasetsVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SPLConverter {
    private static final Logger logger = LoggerFactory.getLogger(SPLConverter.class);

    private SPLConverter() {
    }

    public static SPLParseResult toSPLV1(String splv2, IDatasetResolver datasetResolver) throws SPLParseException {
        Node astNode = SPLConverter.toNode(splv2, datasetResolver);
        SPLParseResult parseResult = new SPLParseResult();
        try {
            String splOutput = astNode.accept(new SplFormatter());
            parseResult.setSplOutput(splOutput);
        }
        catch (RuntimeException e) {
            SPLParseError parseError = new SPLParseError(SPLParseErrorType.ERROR_FORMAT_SPL, e.getMessage(), null, 0, 0, null);
            SPLParseException splEx = new SPLParseException("SPL output failure", e);
            splEx.setCommand("SPL format");
            splEx.setError(parseError);
            logger.error("Failed to format in SPL v1: splv2={}, parseError={}", (Object)splv2, (Object)parseError);
            throw splEx;
        }
        logger.info("Successful to convert to SPL v1: splv2={}, parseResult={}", (Object)splv2, (Object)parseResult);
        return parseResult;
    }

    public static SPLParseResult toAST(String splv2, boolean prettyPrinting, IDatasetResolver datasetResolver) throws SPLParseException {
        SPLParseResult parseResult = SPLConverter.toASTObject(splv2, datasetResolver);
        if (parseResult.hasJsonOutput()) {
            String jsonOutput = parseResult.getAstJson().toString(prettyPrinting ? 4 : 0);
            parseResult.setJsonOutput(jsonOutput);
        }
        logger.info("Successful to generate AST JSON string: splv2={}, parseResult={}", (Object)splv2, (Object)parseResult);
        return parseResult;
    }

    public static SPLParseResult toASTObject(String splv2, IDatasetResolver datasetResolver) throws SPLParseException {
        SPLParseResult parseResult = new SPLParseResult();
        Node astNode = SPLConverter.toNode(splv2, datasetResolver);
        try {
            JSONObject jsonObject = astNode.accept(new JsonFormatter());
            parseResult.setAstJson(jsonObject);
        }
        catch (RuntimeException e) {
            SPLParseError parseError = new SPLParseError(SPLParseErrorType.ERROR_FORMAT_JSON, e.getMessage(), null, 0, 0, null);
            SPLParseException splEx = new SPLParseException("JSON output failure", e);
            splEx.setCommand("JSON format");
            splEx.setError(parseError);
            logger.error("Failed to generate AST JSON object: splv2={}, parseError={}", (Object)splv2, (Object)parseError);
            throw splEx;
        }
        logger.debug("Successful to generate AST JSON object: splv2={}, parseResult={}", (Object)splv2, (Object)parseResult);
        return parseResult;
    }

    private static Node toNode(String splv2, IDatasetResolver datasetResolver) throws SPLParseException {
        SPLParseError parseError;
        CompleteSPLParser parser = new CompleteSPLParser();
        logger.debug("splv2={}, datasetResolver={}", (Object)splv2, (Object)datasetResolver);
        parser.setTokenValidation(true);
        Node astNode = parser.parse(splv2);
        CachedResolverWrapper resolverWrapper = new CachedResolverWrapper(datasetResolver);
        try {
            Set<Dataset> referencedDatasets = astNode.accept(new ReferencedDatasetsVisitor());
            if (!referencedDatasets.isEmpty()) {
                List<IDatasetInfo> list = resolverWrapper.query(Modules.buildWherePredicate(referencedDatasets, resolverWrapper.getModule()));
            }
        }
        catch (RuntimeException e) {
            logger.error("Failed in resolving datasets: splv2={}, datasetResolver={}, error={}", new Object[]{splv2, datasetResolver, e.getMessage()});
        }
        try {
            astNode = astNode.accept(new Expander(resolverWrapper));
        }
        catch (RuntimeException e) {
            parseError = new SPLParseError(SPLParseErrorType.ERROR_AST_EXPAND, e.getMessage(), null, 0, 0, null);
            SPLParseException splEx = new SPLParseException("AST expander failure", e);
            splEx.setCommand("Expander on " + datasetResolver.toString());
            splEx.setError(parseError);
            logger.error("Failed in AST Expander: splv2={}, datasetResolver={}, parseError={}", new Object[]{splv2, datasetResolver, parseError});
            throw splEx;
        }
        try {
            astNode = astNode.accept(new DatasetsQualifierVisitor(resolverWrapper));
        }
        catch (RuntimeException e) {
            parseError = new SPLParseError(SPLParseErrorType.ERROR_AST_EXPAND, e.getMessage(), null, 0, 0, null);
            SPLParseException splEx = new SPLParseException("AST expander failure", e);
            splEx.setCommand("DatasetsQualifierVisitor on " + datasetResolver.toString());
            splEx.setError(parseError);
            logger.error("Failed in AST DatasetsQualifierVisitor: splv2={}, datasetResolver={}, parseError={}", new Object[]{splv2, datasetResolver, parseError});
            throw splEx;
        }
        return astNode;
    }
}

