/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast;

import com.splunk.commons.Defaults;
import com.splunk.commons.util.HttpUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class JsonAstEndpoint {
    private String serverUri;
    private String username;
    private String password;
    private boolean checkedAvailability;
    private boolean isAvailable;

    public JsonAstEndpoint() {
        this(Defaults.DEFAULT_SERVER_URI, "admin", "changeme");
    }

    public JsonAstEndpoint(String serverUri, String username, String password) {
        this.serverUri = serverUri;
        this.username = username;
        this.password = password;
    }

    private JSONObject getJsonAst(JSONObject requestJson) {
        if (requestJson == null) {
            throw new IllegalArgumentException("requestJson must not be null");
        }
        if (!requestJson.has("spl")) {
            throw new IllegalArgumentException("Request JSON must have an 'spl' property.");
        }
        try {
            URL url = new URL(this.serverUri);
            if (url.getProtocol().equals("https") && url.getHost().equals("localhost")) {
                HttpUtils.relaxSSLSigningRequirement();
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            HttpUtils.basicAuthentication(connection, this.username, this.password);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            HttpUtils.writeJsonBody(connection.getOutputStream(), requestJson);
            String ast = HttpUtils.readAll(connection.getInputStream());
            return new JSONObject(ast);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public JSONObject getJsonAst(String spl) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("spl", (Object)spl);
        return this.getJsonAst(requestBody);
    }

    public boolean isAvailable() {
        if (this.checkedAvailability) {
            return this.isAvailable;
        }
        this.checkedAvailability = true;
        String ast = null;
        try {
            ast = this.getJsonAstViaGet("search *");
            this.isAvailable = ast != null;
        }
        catch (Exception e) {
            try {
                ast = null;
                this.isAvailable = ast != null;
            }
            catch (Throwable throwable) {
                this.isAvailable = ast != null;
                throw throwable;
            }
        }
        return this.isAvailable;
    }

    public String getJsonAstViaGet(String spl) {
        String requestPath = String.format("%1$s?q=%2$s", this.serverUri, spl);
        try {
            URL url = new URL(requestPath);
            if (url.getProtocol().equals("https")) {
                HttpUtils.relaxSSLSigningRequirement();
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            HttpUtils.basicAuthentication(connection, this.username, this.password);
            connection.setReadTimeout(5000);
            connection.connect();
            return HttpUtils.readAll(connection.getInputStream());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("error fetching ast json from splunk endpoint", ioe);
        }
    }

    public void setDefaultServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

