/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class CommandDedupVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    @Override
    public Node visitDedupParse(SplunkCommandParser.DedupParseContext ctx) throws IllegalArgumentException {
        SplunkCommandParser.DedupFieldListContext fieldListCtx = ctx.dedupFieldList();
        List<TerminalNode> fieldCtx = fieldListCtx.ID();
        FieldNode[] fieldNodeArray = new FieldNode[fieldCtx.size()];
        for (int i = 0; i < fieldCtx.size(); ++i) {
            fieldNodeArray[i] = Expression.field(fieldCtx.get(i).getText());
        }
        boolean consecutive = false;
        boolean keepEmpty = false;
        boolean keepEvents = false;
        List<SplunkCommandParser.DedupBoolArgContext> boolArgsCtx = ctx.dedupBoolArg();
        for (SplunkCommandParser.DedupBoolArgContext boolArgCtx : boolArgsCtx) {
            SplunkCommandParser.DedupBoolFieldContext dedupBoolFieldContext = boolArgCtx.dedupBoolField();
            boolean boolValue = Boolean.parseBoolean(boolArgCtx.boolValue().getText());
            if (dedupBoolFieldContext.CONSECUTIVE() != null) {
                consecutive = boolValue;
                continue;
            }
            if (dedupBoolFieldContext.KEEPEMPTY() != null) {
                keepEmpty = boolValue;
                continue;
            }
            if (dedupBoolFieldContext.KEEPEVENTS() != null) {
                keepEvents = boolValue;
                continue;
            }
            throw new IllegalArgumentException("Dedup does not support boolean param=" + dedupBoolFieldContext.getText().toLowerCase());
        }
        if (ctx.INTEGER() != null) {
            int limit = Integer.parseInt(ctx.INTEGER().getText());
            if (limit < 1) {
                throw new IllegalArgumentException("Integer argument N must be greater than 0");
            }
            return new DedupCommand(new SearchCommand(), limit, fieldNodeArray, keepEvents, keepEmpty, consecutive, null, false);
        }
        return new DedupCommand(new SearchCommand(), 1, fieldNodeArray, keepEvents, keepEmpty, consecutive, null, false);
    }
}

