/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.CommandStatsVisitor;
import com.splunk.commons.ast.antlr.DatasetsVisitor;
import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.antlr.StatsAndChartVisitor;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandFromVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private final ExpressionVisitor expVisitor = new ExpressionVisitor();
    private final DatasetsVisitor datasetsVisitor = new DatasetsVisitor();
    private final CommandStatsVisitor statsVisitor = new CommandStatsVisitor();
    private final StatsAndChartVisitor statsAndChartVisitor = new StatsAndChartVisitor(false);

    @Override
    public Node visitSelection(SplunkCommandParser.SelectionContext ctx) {
        if (ctx.statsAggregation() != null) {
            return (Node)this.statsVisitor.visit((ParseTree)ctx.statsAggregation());
        }
        if (ctx.nonboolExpression() != null) {
            return (Node)this.expVisitor.visit((ParseTree)ctx.nonboolExpression());
        }
        throw new IllegalArgumentException("SELECT clause must be either an aggregate or a non-bool expression");
    }

    @Override
    public Node visitFromParse(SplunkCommandParser.FromParseContext ctx) {
        int i;
        int numExpr;
        Dataset dataset = (Dataset)this.datasetsVisitor.visit((ParseTree)ctx.datasetParse());
        Node wherePredicate = null;
        ISelection[] selectNodes = null;
        IGroupBy[] groupbyNodes = null;
        IOrdering[] orderbyNodes = null;
        if (ctx.whereClause() != null) {
            wherePredicate = (Node)this.expVisitor.visit((ParseTree)ctx.whereClause().boolExpression());
        }
        if (ctx.selectClause() != null) {
            numExpr = ctx.selectClause().selection().size();
            selectNodes = new ISelection[numExpr];
            for (i = 0; i < numExpr; ++i) {
                selectNodes[i] = (ISelection)this.visit((ParseTree)ctx.selectClause().selection(i));
            }
        }
        if (ctx.groupbyClause() != null) {
            numExpr = ctx.groupbyClause().groupByField().size();
            groupbyNodes = new IGroupBy[numExpr];
            for (i = 0; i < numExpr; ++i) {
                Node groupBy = null;
                try {
                    groupBy = (Node)this.visit((ParseTree)ctx.groupbyClause().groupByField(i));
                    groupbyNodes[i] = (IGroupBy)((Object)groupBy);
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new IllegalArgumentException("Node " + groupBy + " is not a valid group-by field");
                }
            }
        }
        if (ctx.orderbyClause() != null) {
            numExpr = ctx.orderbyClause().ordering().size();
            orderbyNodes = new IOrdering[numExpr];
            for (i = 0; i < numExpr; ++i) {
                SortNode node = (SortNode)this.visit((ParseTree)ctx.orderbyClause().ordering(i));
                orderbyNodes[i] = node;
            }
        }
        return new FromCommand(dataset, (IWherePredicate)((Object)wherePredicate), groupbyNodes, selectNodes, orderbyNodes);
    }

    @Override
    public Node visitOrdering(SplunkCommandParser.OrderingContext ctx) {
        FieldNode orderByNode = new FieldNode(ctx.field().getText());
        SortOrder sortOrder = SortOrder.ASC;
        if (ctx.orderingType() != null) {
            sortOrder = SortOrder.valueOf(ctx.orderingType().getText());
        }
        return new SortNode(orderByNode.getFieldName(), sortOrder);
    }

    @Override
    public Node visitGroupByField(SplunkCommandParser.GroupByFieldContext ctx) {
        SplunkCommandParser.TimeSpanContext timeSpanContext = ctx.timeSpan();
        if (timeSpanContext != null) {
            if (timeSpanContext instanceof SplunkCommandParser.TimeSpanFuncContext) {
                SplunkCommandParser.TimeSpanFuncContext timeSpanFuncContext = (SplunkCommandParser.TimeSpanFuncContext)timeSpanContext;
                return (Node)this.statsAndChartVisitor.visit((ParseTree)timeSpanFuncContext);
            }
            throw new IllegalArgumentException("Invalid time span: " + timeSpanContext.getText());
        }
        if (ctx.field() != null) {
            return (Node)this.expVisitor.visit((ParseTree)ctx.field());
        }
        throw new IllegalArgumentException("Invalid type of node provided for Group by");
    }
}

