/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.SubsearchVisitor;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.Search;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchInNode;
import com.splunk.commons.ast.nodes.search.SearchLeafNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchPhraseNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchTermNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandSearchVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    @Override
    public Node visitSearchParse(SplunkCommandParser.SearchParseContext ctx) {
        return new SearchCommand((IPredicate)this.visit((ParseTree)ctx.searchExpressionParse()));
    }

    @Override
    public Node visitSearchExpressionParse(SplunkCommandParser.SearchExpressionParseContext ctx) {
        ArrayList<ISearchPredicate> predicateList = new ArrayList<ISearchPredicate>();
        List<SplunkCommandParser.SearchExpressionContext> searchExpressions = ctx.searchExpression();
        CommandNode subSearchNode = null;
        for (SplunkCommandParser.SearchExpressionContext searchExpression : searchExpressions) {
            if (searchExpression instanceof SplunkCommandParser.SubSearchExpressionContext) {
                if (subSearchNode != null) {
                    throw new IllegalArgumentException("More than one sub-searches are not allowed in outermost search command");
                }
                subSearchNode = (CommandNode)this.visit((ParseTree)searchExpression);
                predicateList.add(new SearchSubSearchPredicateNode(subSearchNode));
                continue;
            }
            predicateList.add((ISearchPredicate)this.visit((ParseTree)searchExpression));
        }
        if (predicateList.size() > 1) {
            ISearchPredicate[] predicates = new ISearchPredicate[predicateList.size()];
            predicateList.toArray(predicates);
            return new SearchAndNode(predicates);
        }
        if (predicateList.size() == 1) {
            return (Node)predicateList.get(0);
        }
        return null;
    }

    @Override
    public Node visitParenSearchExpression(SplunkCommandParser.ParenSearchExpressionContext ctx) {
        return (Node)this.visit((ParseTree)ctx.searchExpression());
    }

    @Override
    public Node visitNotSearchExpression(SplunkCommandParser.NotSearchExpressionContext ctx) {
        Node predicate = (Node)this.visit((ParseTree)ctx.searchExpression());
        return new SearchNotNode((IPredicate)((Object)predicate));
    }

    @Override
    public Node visitBinarySearchExpression(SplunkCommandParser.BinarySearchExpressionContext ctx) {
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        if (ctx.op.AND() != null) {
            return Search.and((IPredicate)((Object)left), (IPredicate)((Object)right));
        }
        if (ctx.op.OR() != null) {
            return Search.or((IPredicate)((Object)left), (IPredicate)((Object)right));
        }
        throw new IllegalArgumentException("This should not happen");
    }

    @Override
    public Node visitComparatorSearchExpression(SplunkCommandParser.ComparatorSearchExpressionContext ctx) {
        Operator op = Operator.load(ctx.op.getText());
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        if (right instanceof SearchTermNode || right instanceof SearchPhraseNode) {
            return new SearchComparisonNode(op, (FieldNode)left, new StringNode(((SearchQuotableNode)right).getValue()), ((SearchLeafNode)right).is_negated(), false, ((SearchQuotableNode)right).is_quoted(), false, ((SearchLeafNode)right).getModifier());
        }
        throw new IllegalArgumentException("Comparisons must be between field and strings");
    }

    @Override
    public Node visitInSearchExpression(SplunkCommandParser.InSearchExpressionContext ctx) {
        FieldNode field = (FieldNode)this.visit((ParseTree)ctx.searchField());
        List<SplunkCommandParser.SearchValueContext> values = ctx.values;
        TypeNode[] nodeArgs = new TypeNode[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            nodeArgs[i] = (TypeNode)this.visit((ParseTree)values.get(i));
        }
        return new SearchInNode(field, nodeArgs);
    }

    @Override
    public Node visitSearchField(SplunkCommandParser.SearchFieldContext ctx) {
        return new FieldNode(ctx.getText());
    }

    @Override
    public Node visitSearchValue(SplunkCommandParser.SearchValueContext ctx) {
        if (ctx.QSTRING() != null) {
            String val = ctx.QSTRING().getText().replaceAll("^\"|\"$", "");
            return new SearchPhraseNode(val, false, true, SearchModifier.NONE);
        }
        return new SearchTermNode(ctx.getText(), false, false, SearchModifier.NONE);
    }

    @Override
    public Node visitCaseSearchExpression(SplunkCommandParser.CaseSearchExpressionContext ctx) {
        if (ctx.QSTRING() != null) {
            String val = ctx.QSTRING().getText().replaceAll("^\"|\"$", "");
            return new SearchPhraseNode(val, false, true, SearchModifier.CASE);
        }
        List<SplunkCommandParser.SearchValueContext> values = ctx.searchValue();
        StringBuilder string = new StringBuilder();
        for (SplunkCommandParser.SearchValueContext value : values) {
            string.append(value.getText());
            string.append(' ');
        }
        return new SearchPhraseNode(string.toString().trim(), false, false, SearchModifier.CASE);
    }

    @Override
    public Node visitTermSearchExpression(SplunkCommandParser.TermSearchExpressionContext ctx) {
        if (ctx.QSTRING() != null) {
            String val = ctx.QSTRING().getText().replaceAll("^\"|\"$", "");
            return new SearchPhraseNode(val, false, true, SearchModifier.TERM);
        }
        List<SplunkCommandParser.SearchValueContext> values = ctx.searchValue();
        StringBuilder string = new StringBuilder();
        for (SplunkCommandParser.SearchValueContext value : values) {
            string.append(value.getText());
            string.append(' ');
        }
        return new SearchPhraseNode(string.toString().trim(), false, false, SearchModifier.TERM);
    }

    @Override
    public Node visitSubSearchExpression(SplunkCommandParser.SubSearchExpressionContext ctx) {
        return (Node)new SubsearchVisitor().visit((ParseTree)ctx.subsearchParse());
    }
}

