/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandSortVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private final ExpressionVisitor expressionVisitor = new ExpressionVisitor();

    @Override
    public Node visitSortParse(SplunkCommandParser.SortParseContext ctx) {
        return (Node)this.visit((ParseTree)ctx.sortExpression());
    }

    @Override
    public Node visitSortExpression(SplunkCommandParser.SortExpressionContext ctx) {
        List<SplunkCommandParser.SortParamContext> sortParams = ctx.sortParam();
        IOrdering[] paramNodes = new SortNode[sortParams.size()];
        for (int i = 0; i < sortParams.size(); ++i) {
            paramNodes[i] = (SortNode)this.visit((ParseTree)sortParams.get(i));
            if (ctx.sortOrderDesc() == null) continue;
            paramNodes[i] = new SortNode(((SortNode)paramNodes[i]).getField().getFieldName(), ((SortNode)paramNodes[i]).getSortOrder() == SortOrder.DESC ? SortOrder.ASC : SortOrder.DESC, ((SortNode)paramNodes[i]).getFieldType());
        }
        if (ctx.INTEGER() != null) {
            return new SortCommand(new SearchCommand(), paramNodes, Integer.parseInt(ctx.INTEGER().getText()));
        }
        return new SortCommand(new SearchCommand(), paramNodes);
    }

    @Override
    public Node visitSortParam(SplunkCommandParser.SortParamContext ctx) {
        SortNode sortField = (SortNode)this.visit((ParseTree)ctx.sortField());
        if (ctx.MINUS() != null) {
            return new SortNode(sortField.getField(), SortOrder.DESC, sortField.getFieldType());
        }
        return sortField;
    }

    @Override
    public Node visitSortFieldNoType(SplunkCommandParser.SortFieldNoTypeContext ctx) {
        FieldNode field = (FieldNode)this.expressionVisitor.visit((ParseTree)ctx.field());
        return new SortNode(field, SortOrder.ASC, FieldType.AUTO);
    }

    @Override
    public Node visitSortFieldWithType(SplunkCommandParser.SortFieldWithTypeContext ctx) {
        FieldType fieldType = FieldType.valueOf(ctx.sortFieldType().getText().toUpperCase());
        FieldNode field = (FieldNode)this.expressionVisitor.visit((ParseTree)ctx.field());
        return new SortNode(field, SortOrder.ASC, fieldType);
    }
}

