/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.antlr.StatsAndChartVisitor;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.TimechartCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.util.VisitorUtil;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandTimechartVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private final ExpressionVisitor expressionVisitor = new ExpressionVisitor();
    private final StatsAndChartVisitor statsAndChartVisitor = new StatsAndChartVisitor(false);

    @Override
    public Node visitTimechartParse(SplunkCommandParser.TimechartParseContext ctx) throws SPLParseException {
        StringNode sep = null;
        StringNode format = null;
        BooleanNode partial = null;
        BooleanNode cont = null;
        BooleanNode fixedRange = null;
        NumberNode limit = null;
        StringNode agg = null;
        ArrayList<SplunkCommandParser.BinOptionsContext> binOptsCtx = new ArrayList<SplunkCommandParser.BinOptionsContext>();
        for (SplunkCommandParser.TimechartOptsContext timechartOptsContext : ctx.timechartOpts()) {
            sep = VisitorUtil.visitAtMostOnce("sep", (ParseTree)timechartOptsContext.tcSepOpt(), sep, this);
            format = VisitorUtil.visitAtMostOnce("format", (ParseTree)timechartOptsContext.tcFormatOpt(), format, this);
            partial = VisitorUtil.visitAtMostOnce("partial", (ParseTree)timechartOptsContext.tcPartialOpt(), partial, this);
            cont = VisitorUtil.visitAtMostOnce("cont", (ParseTree)timechartOptsContext.tcContOpt(), cont, this);
            fixedRange = VisitorUtil.visitAtMostOnce("fixedrange", (ParseTree)timechartOptsContext.tcFixedRangeOpt(), fixedRange, this);
            limit = VisitorUtil.visitAtMostOnce("limit", (ParseTree)timechartOptsContext.tcLimitOpt(), limit, this);
            agg = VisitorUtil.visitAtMostOnce("agg", (ParseTree)timechartOptsContext.tcAggOpt(), agg, this);
            if (timechartOptsContext.binOptions() == null) continue;
            binOptsCtx.add(timechartOptsContext.binOptions());
        }
        BinOptionsNode binOptions = this.statsAndChartVisitor.visitBinOptionsAtMostOnce(binOptsCtx);
        ArrayList<AggregateNode> aggregates = new ArrayList<AggregateNode>();
        for (SplunkCommandParser.TimechartAggregationContext aggr : ctx.timechartAggregation()) {
            aggregates.add(this.visitTimechartAggregation(aggr));
        }
        IGroupBy iGroupBy = ctx.timechartSplitBy() == null ? null : (IGroupBy)this.statsAndChartVisitor.visit((ParseTree)ctx.timechartSplitBy());
        return new TimechartCommand((CommandNode)new SearchCommand(), sep, format, partial, cont, fixedRange, limit, agg, binOptions, iGroupBy, aggregates.toArray(new AggregateNode[0]));
    }

    @Override
    public AggregateNode visitTimechartAggregation(SplunkCommandParser.TimechartAggregationContext ctx) {
        SplunkCommandParser.StatsAggregationContext statsAgg = ctx.statsAggregation();
        SplunkCommandParser.TimeAggregationContext timeAgg = ctx.timeAggregation();
        SplunkCommandParser.EvalAggregationContext evalAgg = ctx.evalAggregation();
        if (statsAgg != null) {
            return this.statsAndChartVisitor.visitStatsAggregation(statsAgg);
        }
        if (timeAgg != null) {
            return this.statsAndChartVisitor.visitTimeAggregation(timeAgg);
        }
        if (evalAgg != null) {
            return this.statsAndChartVisitor.visitEvalAggregation(evalAgg);
        }
        throw new UnsupportedOperationException("Unsupported aggregation: " + ctx.getText());
    }

    @Override
    public Node visitTcSepOpt(SplunkCommandParser.TcSepOptContext ctx) {
        return (Node)this.expressionVisitor.visit((ParseTree)ctx.genericstring());
    }

    @Override
    public Node visitTcFormatOpt(SplunkCommandParser.TcFormatOptContext ctx) {
        return (Node)this.expressionVisitor.visit((ParseTree)ctx.genericstring());
    }

    @Override
    public Node visitTcAggOpt(SplunkCommandParser.TcAggOptContext ctx) {
        return new StringNode(ctx.statsFunctionName().getText());
    }

    @Override
    public Node visitTcLimitOpt(SplunkCommandParser.TcLimitOptContext ctx) {
        return new NumberNode(Integer.parseInt(ctx.INTEGER().getText()));
    }

    @Override
    public Node visitTcContOpt(SplunkCommandParser.TcContOptContext ctx) {
        return BooleanNode.load(ctx.boolValue().getText());
    }

    @Override
    public Node visitTcFixedRangeOpt(SplunkCommandParser.TcFixedRangeOptContext ctx) {
        return BooleanNode.load(ctx.boolValue().getText());
    }

    @Override
    public Node visitTcPartialOpt(SplunkCommandParser.TcPartialOptContext ctx) {
        return BooleanNode.load(ctx.getText());
    }
}

