/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.InNode;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    @Override
    public Node visitNonboolExpressionWCQstring(SplunkCommandParser.NonboolExpressionWCQstringContext ctx) {
        return new StringNode(ctx.WCQSTRING().getText().replaceAll("^\"|\"$", ""));
    }

    @Override
    public Node visitNonboolExpressionQstring(SplunkCommandParser.NonboolExpressionQstringContext ctx) {
        return new StringNode(ctx.QSTRING().getText().replaceAll("^\"|\"$", ""));
    }

    @Override
    public StringNode visitGenericstring(SplunkCommandParser.GenericstringContext ctx) {
        if (ctx.QSTRING() != null) {
            return new StringNode(ctx.QSTRING().getText().replaceAll("^\"|\"$", ""));
        }
        if (ctx.WCQSTRING() != null) {
            return new StringNode(ctx.WCQSTRING().getText().replaceAll("^\"|\"$", ""));
        }
        throw new SPLParseException("Failed to parse regexExpression: Only QSTRING and WCQSTRING parser rules are supported. regexExpression=[" + ctx.getText() + ']');
    }

    protected NavigationNode buildNavNode(List<String> identifiers) {
        if (identifiers.size() < 2) {
            throw new IllegalArgumentException("Unexpected exception.  Improper parsing of Navigation field");
        }
        NavigationNode navExpr = Expression.navigation(identifiers.get(0));
        for (int i = 1; i < identifiers.size() - 1; ++i) {
            navExpr = navExpr.navigate(identifiers.get(i));
        }
        return navExpr;
    }

    @Override
    public Node visitNonboolExpressionNavfield(SplunkCommandParser.NonboolExpressionNavfieldContext ctx) {
        List<String> identifiers = Arrays.asList(ctx.NAVFIELD().getSymbol().getText().split("\\."));
        if (identifiers.size() < 2) {
            throw new IllegalArgumentException("Unexpected exception.  Improper parsing of Navigation field");
        }
        NavigationNode navExpr = this.buildNavNode(identifiers);
        return navExpr.field(identifiers.get(identifiers.size() - 1));
    }

    @Override
    public Node visitBoolExpressionNavfield(SplunkCommandParser.BoolExpressionNavfieldContext ctx) {
        List<String> identifiers = Arrays.asList(ctx.NAVFIELD().getSymbol().getText().split("\\."));
        if (identifiers.size() < 2) {
            throw new IllegalArgumentException("Unexpected exception.  Improper parsing of Navigation field");
        }
        NavigationNode navExpr = this.buildNavNode(identifiers);
        String lastId = identifiers.get(identifiers.size() - 1);
        if (lastId.equals("any")) {
            return navExpr.any((IWherePredicate)this.visit((ParseTree)ctx.boolExpression()));
        }
        if (lastId.equals("all")) {
            return navExpr.all((IWherePredicate)this.visit((ParseTree)ctx.boolExpression()));
        }
        throw new IllegalArgumentException("Unsupported navigation function for: " + ctx.getText());
    }

    @Override
    public Node visitField(SplunkCommandParser.FieldContext ctx) {
        if (ctx.QFIELD() != null) {
            return this.createQuotedFieldNode(ctx.QFIELD().getText());
        }
        return new FieldNode(ctx.getText());
    }

    @Override
    public Node visitGenericfield(SplunkCommandParser.GenericfieldContext ctx) {
        if (ctx.field() != null) {
            return (Node)this.visit((ParseTree)ctx.field());
        }
        return this.createQuotedFieldNode(ctx.getText());
    }

    @Override
    public Node visitNumber(SplunkCommandParser.NumberContext ctx) {
        String str = ctx.getText();
        if (ctx.INTEGER() != null) {
            return new NumberNode(Integer.parseInt(str));
        }
        return new NumberNode(Double.parseDouble(str));
    }

    @Override
    public Node visitBoolExpressionCompare(SplunkCommandParser.BoolExpressionCompareContext ctx) {
        Operator op = Operator.load(ctx.op.getText());
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return new ComparisonNode(op, (TypeNode)left, (TypeNode)right);
    }

    @Override
    public Node visitBoolExpressionUnary(SplunkCommandParser.BoolExpressionUnaryContext ctx) {
        SplunkCommandParser.UnaryOperatorContext unaryCtx = ctx.unaryOperator();
        if (unaryCtx.NOT() != null) {
            Node predicate = (Node)this.visit((ParseTree)ctx.boolExpression());
            return new NotNode((IPredicate)((Object)predicate));
        }
        throw new IllegalArgumentException("Unsupported unary operator: " + unaryCtx.getText());
    }

    @Override
    public Node visitBoolExpressionBinaryEquality(SplunkCommandParser.BoolExpressionBinaryEqualityContext ctx) {
        Operator op = Operator.load(ctx.op.getText());
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return new ComparisonNode(op, (TypeNode)left, (TypeNode)right);
    }

    @Override
    public Node visitBoolExpressionAnd(SplunkCommandParser.BoolExpressionAndContext ctx) {
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return Expression.and((IPredicate)((Object)left), (IPredicate)((Object)right));
    }

    @Override
    public Node visitBoolExpressionOr(SplunkCommandParser.BoolExpressionOrContext ctx) {
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return Expression.or((IPredicate)((Object)left), (IPredicate)((Object)right));
    }

    @Override
    public Node visitNonboolExpressionConcat(SplunkCommandParser.NonboolExpressionConcatContext ctx) {
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return FunctionNode.concat((TypeNode)left, (TypeNode)right);
    }

    @Override
    public Node visitNonboolExpressionMultiply(SplunkCommandParser.NonboolExpressionMultiplyContext ctx) {
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return new FunctionNode(ctx.op.getText(), (TypeNode)left, (TypeNode)right);
    }

    @Override
    public Node visitNonboolExpressionAdd(SplunkCommandParser.NonboolExpressionAddContext ctx) {
        Node left = (Node)this.visit((ParseTree)ctx.left);
        Node right = (Node)this.visit((ParseTree)ctx.right);
        return new FunctionNode(ctx.op.getText(), (TypeNode)left, (TypeNode)right);
    }

    @Override
    public Node visitAssignExpression(SplunkCommandParser.AssignExpressionContext ctx) {
        FieldNode field = (FieldNode)this.visit((ParseTree)ctx.field());
        TypeNode evalExp = (TypeNode)this.visit((ParseTree)ctx.expression());
        return new AssignmentNode(field.getFieldName(), evalExp);
    }

    @Override
    public Node visitBoolExpressionBracket(SplunkCommandParser.BoolExpressionBracketContext ctx) {
        return (Node)this.visit((ParseTree)ctx.boolExpression());
    }

    @Override
    public Node visitNonboolExpressionBracket(SplunkCommandParser.NonboolExpressionBracketContext ctx) {
        return (Node)this.visit((ParseTree)ctx.nonboolExpression());
    }

    @Override
    public Node visitBaseEvalExpression(SplunkCommandParser.BaseEvalExpressionContext ctx) {
        TypeNode evalExp = null;
        FieldNode field = (FieldNode)this.visit((ParseTree)ctx.field());
        if (ctx.nonboolExpression() != null) {
            evalExp = (TypeNode)this.visit((ParseTree)ctx.nonboolExpression());
            return new AssignmentNode(field, evalExp);
        }
        if (ctx.boolFunction() != null) {
            evalExp = (TypeNode)this.visitBoolFunction(ctx.boolFunction());
        } else if (ctx.nonboolFunction() != null) {
            evalExp = (TypeNode)this.visitNonboolFunction(ctx.nonboolFunction());
        }
        return new AssignmentNode(field, evalExp);
    }

    @Override
    public Node visitBoolExpressionFunc(SplunkCommandParser.BoolExpressionFuncContext ctx) {
        return (Node)this.visit((ParseTree)ctx.boolFunction());
    }

    @Override
    public Node visitNonboolExpressionFunc(SplunkCommandParser.NonboolExpressionFuncContext ctx) {
        return (Node)this.visit((ParseTree)ctx.nonboolFunction());
    }

    @Override
    public Node visitNonboolExpressionUser(SplunkCommandParser.NonboolExpressionUserContext ctx) {
        return (Node)this.visit((ParseTree)ctx.userFunction());
    }

    @Override
    public Node visitUserFunction(SplunkCommandParser.UserFunctionContext ctx) {
        List<SplunkCommandParser.ExpressionContext> args = ctx.expression();
        TypeNode[] typeNodes = new TypeNode[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            typeNodes[i] = (TypeNode)this.visit((ParseTree)args.get(i).nonboolExpression());
        }
        return new FunctionNode(ctx.ID().getText().toLowerCase(), typeNodes);
    }

    @Override
    public Node visitBoolValue(SplunkCommandParser.BoolValueContext ctx) {
        return BooleanNode.load(ctx.getText());
    }

    @Override
    public Node visitBoolFunction(SplunkCommandParser.BoolFunctionContext ctx) {
        TypeNode[] args;
        SplunkCommandParser.BoolFunctionNameContext fn = ctx.boolFunctionName();
        FunctionNode.FunctionName fname = FunctionNode.FunctionName.lookup(fn.getText());
        if (fname.isUnsupportedBySPLV2()) {
            throw new SPLParseException("Failed to parse function due to unsupported by SPL v2 syntax. function=" + fname.getName());
        }
        switch (fname) {
            case cidrmatch: 
            case like: 
            case match: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2);
                break;
            }
            case in: {
                TypeNode[] args2 = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.ANY, -1, -1, ArgType.ANY);
                return new InNode(args2);
            }
            case searchmatch: 
            case isbool: 
            case isint: 
            case isnotnull: 
            case isnull: 
            case isnum: 
            case isstr: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1, ArgType.ANY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid function is found: " + (Object)((Object)fname));
            }
        }
        return FunctionNode.create(fname, args);
    }

    @Override
    public Node visitNonboolExpressionEvalFunc(SplunkCommandParser.NonboolExpressionEvalFuncContext ctx) {
        return this.visitStatsEvalFunction(ctx.statsEvalFunction());
    }

    @Override
    public Node visitNonboolExpressionStatsFunction(SplunkCommandParser.NonboolExpressionStatsFunctionContext ctx) {
        return this.visitStatsFunction(ctx.statsFunction());
    }

    @Override
    public Node visitStatsEvalFunction(SplunkCommandParser.StatsEvalFunctionContext ctx) {
        throw new UnsupportedOperationException("eval function is not supported.");
    }

    @Override
    public Node visitStatsFunction(SplunkCommandParser.StatsFunctionContext ctx) {
        throw new UnsupportedOperationException("stats function is not supported.");
    }

    @Override
    public Node visitNonboolFunction(SplunkCommandParser.NonboolFunctionContext ctx) {
        TypeNode[] args;
        SplunkCommandParser.NonboolFunctionNameContext fn = ctx.nonboolFunctionName();
        FunctionNode.FunctionName fname = FunctionNode.FunctionName.lookup(fn.getText());
        switch (fname) {
            case caseF: 
            case validate: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.EVEN, ArgType.EVENTH_ARG_IS_BOOL);
                break;
            }
            case coalesce: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.ANY, ArgType.NO_ARG_IS_BOOL);
                break;
            }
            case ifF: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 3, ArgType.FIRST_ARG_IS_BOOL);
                break;
            }
            case nullif: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2, ArgType.ANY);
                break;
            }
            case printf: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN, 0, ArgType.ANY);
                break;
            }
            case tonumber: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 0, 3, ArgType.NO_ARG_IS_BOOL);
                if (args.length != 2 || !(args[1] instanceof NumberNode)) break;
                boolean failed = false;
                try {
                    int base = Integer.parseInt(args[1].toString());
                    if (base < 2 || base > 36) {
                        failed = true;
                    }
                }
                catch (NumberFormatException e) {
                    failed = true;
                }
                if (!failed) break;
                throw new IllegalArgumentException("Failed to parse function tonumber: second argument '" + args[1].toString() + "' must be an integer between 2 to 36.");
            }
            case tostring: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 0, 3, ArgType.ANY);
                if (args.length != 2 || !(args[1] instanceof StringNode) || args[1].toString().equals("hex") || args[1].toString().equals("commas") || args[1].toString().equals("duration")) break;
                throw new IllegalArgumentException("Failed to parse function tostring due to invalid format for the second argument:valid formats are 'hex', 'commas' or 'duration'.");
            }
            case md5: 
            case sha1: 
            case sha256: 
            case sha512: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1);
                break;
            }
            case now: 
            case time: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 0);
                break;
            }
            case relative_time: 
            case strftime: 
            case strptime: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2);
                break;
            }
            case typeof: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1, ArgType.ANY);
                break;
            }
            case pi: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 0);
                break;
            }
            case abs: 
            case ceiling: 
            case exact: 
            case exp: 
            case floor: 
            case ln: 
            case sigfig: 
            case sqrt: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1);
                break;
            }
            case pow: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2);
                ExpressionVisitor.ensureIntegerIfNumberNode(args[1], fname);
                break;
            }
            case log: 
            case round: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 0, 3);
                if (args.length != 2) break;
                ExpressionVisitor.ensureIntegerIfNumberNode(args[1], fname);
                break;
            }
            case commands: 
            case mvcount: 
            case mvdedup: 
            case mvsort: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1);
                break;
            }
            case mvappend: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN, 0);
                break;
            }
            case mvfilter: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1, ArgType.FIRST_ARG_IS_BOOL);
                break;
            }
            case mvfind: 
            case mvjoin: 
            case split: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2);
                break;
            }
            case mvindex: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 1, 4);
                ExpressionVisitor.ensureIntegerIfNumberNode(args[1], fname);
                if (args.length != 3) break;
                ExpressionVisitor.ensureIntegerIfNumberNode(args[2], fname);
                break;
            }
            case mvrange: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 1, 4);
                ExpressionVisitor.ensureIntegerIfNumberNode(args[0], fname);
                ExpressionVisitor.ensureIntegerIfNumberNode(args[1], fname);
                break;
            }
            case mvzip: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 1, 4);
                break;
            }
            case random: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 0);
                break;
            }
            case max: 
            case min: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN, 0);
                break;
            }
            case len: 
            case lower: 
            case upper: 
            case urldecode: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1);
                break;
            }
            case spath: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2);
                break;
            }
            case replace: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 3);
                break;
            }
            case ltrim: 
            case rtrim: 
            case trim: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN, 0, ArgType.NO_ARG_IS_BOOL);
                break;
            }
            case substr: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, ArgSizeComparator.GREATER_THAN_LESS_THAN, 1, 4);
                ExpressionVisitor.ensureIntegerIfNumberNode(args[1], fname);
                if (args.length != 3) break;
                ExpressionVisitor.ensureIntegerIfNumberNode(args[2], fname);
                break;
            }
            case acos: 
            case acosh: 
            case asin: 
            case asinh: 
            case atan: 
            case atanh: 
            case cos: 
            case cosh: 
            case sin: 
            case sinh: 
            case tan: 
            case tanh: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 1);
                break;
            }
            case atan2: 
            case hypot: {
                args = this.getArgs(ctx.getText(), ctx.expression(), fname, 2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid function is found: " + (Object)((Object)fname));
            }
        }
        return FunctionNode.create(fname, args);
    }

    private static void ensureIntegerIfNumberNode(TypeNode n, FunctionNode.FunctionName functionName) {
        boolean error = n instanceof StringNode;
        if (!error && n instanceof NumberNode) {
            try {
                Integer.parseInt(n.toString());
            }
            catch (NumberFormatException e) {
                error = true;
            }
        }
        if (error) {
            throw new IllegalArgumentException("Failed to parse function " + (Object)((Object)functionName) + ": the argument '" + n.toString() + "' is not an integer.");
        }
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, int numArgs) {
        return this.getArgs(rawText, args, functionName, ArgSizeComparator.EQUAL, numArgs, numArgs, ArgType.NO_ARG_IS_BOOL);
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, ArgSizeComparator comparator, int numArgs) {
        return this.getArgs(rawText, args, functionName, comparator, numArgs, numArgs, ArgType.NO_ARG_IS_BOOL);
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, int numArgs, ArgType argType) {
        return this.getArgs(rawText, args, functionName, ArgSizeComparator.EQUAL, numArgs, numArgs, argType);
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, ArgSizeComparator comparator, ArgType argType) {
        return this.getArgs(rawText, args, functionName, comparator, -1, -1, argType);
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, ArgSizeComparator comparator, int numArgs, ArgType argType) {
        return this.getArgs(rawText, args, functionName, comparator, numArgs, numArgs, argType);
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, ArgSizeComparator comparator, int greaterThanNumArgs, int lessThanNumArgs) {
        return this.getArgs(rawText, args, functionName, comparator, greaterThanNumArgs, lessThanNumArgs, ArgType.NO_ARG_IS_BOOL);
    }

    private TypeNode[] getArgs(String rawText, List<SplunkCommandParser.ExpressionContext> args, FunctionNode.FunctionName functionName, ArgSizeComparator comparator, int greaterThanNumArgs, int lessThanNumArgs, ArgType argType) {
        switch (comparator) {
            case EQUAL: {
                if (greaterThanNumArgs == lessThanNumArgs && args.size() == greaterThanNumArgs) break;
                throw new IllegalArgumentException((Object)((Object)functionName) + " takes only " + greaterThanNumArgs + " arguments: " + rawText);
            }
            case GREATER_THAN: {
                if (args.size() > greaterThanNumArgs) break;
                throw new IllegalArgumentException((Object)((Object)functionName) + " takes at least " + (greaterThanNumArgs + 1) + " arguments: " + rawText);
            }
            case LESS_THAN: {
                if (args.size() < lessThanNumArgs) break;
                throw new IllegalArgumentException((Object)((Object)functionName) + " takes less than " + lessThanNumArgs + " arguments: " + rawText);
            }
            case GREATER_THAN_LESS_THAN: {
                if (args.size() > greaterThanNumArgs && args.size() < lessThanNumArgs) break;
                throw new IllegalArgumentException((Object)((Object)functionName) + " takes at least " + (greaterThanNumArgs + 1) + " and less than " + lessThanNumArgs + " arguments: " + rawText);
            }
            case EVEN: {
                if (args.size() % 2 == 0) break;
                throw new IllegalArgumentException((Object)((Object)functionName) + " takes only even number of arguments: " + rawText);
            }
        }
        TypeNode[] typeNodes = new TypeNode[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            typeNodes[i] = i == 0 && argType == ArgType.FIRST_ARG_IS_BOOL || i % 2 == 0 && argType == ArgType.EVENTH_ARG_IS_BOOL || argType == ArgType.ANY && args.get(i).boolExpression() != null ? (TypeNode)this.visit((ParseTree)args.get(i).boolExpression()) : (TypeNode)this.visit((ParseTree)args.get(i).nonboolExpression());
        }
        return typeNodes;
    }

    private FieldNode createQuotedFieldNode(String text) {
        return new FieldNode(text.replaceAll("^'|'$|^\"|\"$", ""));
    }

    private static enum ArgType {
        FIRST_ARG_IS_BOOL,
        EVENTH_ARG_IS_BOOL,
        NO_ARG_IS_BOOL,
        ANY;

    }

    private static enum ArgSizeComparator {
        EQUAL,
        GREATER_THAN,
        LESS_THAN,
        GREATER_THAN_LESS_THAN,
        EVEN,
        ANY;

    }
}

