/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.SPLParseError;
import com.splunk.commons.ast.SPLParseErrorType;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplErrorListener
extends BaseErrorListener {
    private final String name;
    private SPLParseError error;
    private static final Logger logger = LoggerFactory.getLogger(SplErrorListener.class);

    public SplErrorListener(String name) {
        this.name = name;
    }

    public SPLParseError getError() {
        return this.error;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String tokenName = ((Token)offendingSymbol).getText();
        String ruleName = null;
        SPLParseErrorType errorType = SPLParseErrorType.ERROR_UNKNOWN;
        if (recognizer instanceof Parser) {
            Parser parser = (Parser)recognizer;
            int ruleIndex = parser.getContext().getRuleIndex();
            ruleName = parser.getRuleNames()[ruleIndex];
            errorType = SPLParseErrorType.ERROR_SPL_PARSE;
        } else if (recognizer instanceof Lexer) {
            Lexer lexer = (Lexer)recognizer;
            ruleName = lexer.getVocabulary().getSymbolicName(((Token)offendingSymbol).getType());
            errorType = SPLParseErrorType.ERROR_SPL_LEX;
        }
        logger.warn("SplErrorListener: name={}, error={}, state={}, line:char={}:{}, token={}, rule={}", new Object[]{this.name, msg, recognizer.getState(), line, charPositionInLine, tokenName, ruleName});
        if (this.error == null) {
            this.error = new SPLParseError(errorType, msg, ruleName, line, charPositionInLine, tokenName);
        }
    }
}

