/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.matchers;

import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TermMatcher
implements IMatcher {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private static final Pattern _patternBuildHelper = Pattern.compile("[^*]+|(\\*)");
    private static final Pattern _patternBuildHelper_like = Pattern.compile("[^%_]+|(\\%)|(\\_)");
    private static final String regexEscapePrefix = "\\\\Q";
    private static final String regexEscapeSuffix = "\\\\E";
    private final List<String> parts = new ArrayList<String>();

    public TermMatcher(String pattern, boolean caseSensitive) {
        Matcher matcher = _patternBuildHelper.matcher(pattern);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(stringBuffer, ".*");
                if (matcher.start(1) == 0) {
                    this.parts.add("");
                }
                if (matcher.end(1) != pattern.length()) continue;
                this.parts.add("");
                continue;
            }
            this.parts.add(matcher.group(0));
            if (!caseSensitive) {
                matcher.appendReplacement(stringBuffer, "(?i)\\\\Q" + matcher.group(0) + regexEscapeSuffix + "(?-i)");
                continue;
            }
            matcher.appendReplacement(stringBuffer, regexEscapePrefix + matcher.group(0) + regexEscapeSuffix);
        }
        matcher.appendTail(stringBuffer);
        this.pattern = Pattern.compile(stringBuffer.toString());
    }

    public String[] parts() {
        return this.parts.toArray(new String[0]);
    }

    public TermMatcher(String pattern) {
        this(pattern, false);
    }

    public TermMatcher(String pattern, FunctionNode.FunctionName like) {
        Matcher matcher = _patternBuildHelper_like.matcher(pattern);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(stringBuffer, ".*");
                continue;
            }
            if (matcher.group(2) != null) {
                matcher.appendReplacement(stringBuffer, ".");
                continue;
            }
            this.parts.add(matcher.group(0));
            matcher.appendReplacement(stringBuffer, regexEscapePrefix + matcher.group(0) + regexEscapeSuffix);
        }
        matcher.appendTail(stringBuffer);
        this.pattern = Pattern.compile(stringBuffer.toString());
    }

    public boolean match(String value) {
        return this.pattern.matcher(value).matches();
    }
}

