/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.matchers;

import com.splunk.commons.ast.matchers.TermMatcher;
import java.util.HashSet;
import java.util.Set;

public final class TermSetUtils {
    private TermSetUtils() {
    }

    public static Set<String> intersect(Set<String> lhs, Set<String> rhs) {
        HashSet<String> intersection = new HashSet<String>();
        if (lhs.isEmpty()) {
            intersection.addAll(rhs);
            return intersection;
        }
        if (rhs.isEmpty()) {
            intersection.addAll(lhs);
            return intersection;
        }
        for (String name : lhs) {
            boolean handled = false;
            if (name.equals("*")) {
                intersection.addAll(rhs);
                handled = true;
            } else if (rhs.contains(name)) {
                intersection.add(name);
                handled = true;
            } else if (rhs.contains("*")) {
                intersection.add(name);
                handled = true;
            }
            if (handled) continue;
            if (name.contains("*")) {
                TermMatcher matcher = new TermMatcher(name);
                for (String possible : rhs) {
                    if (!matcher.match(possible)) continue;
                    intersection.add(possible);
                }
            }
            for (String existing : rhs) {
                TermMatcher matcher;
                if (!existing.contains("*") || !(matcher = new TermMatcher(existing)).match(name)) continue;
                intersection.add(name);
            }
        }
        return intersection;
    }

    public static Set<String> union(Set<String> lhs, Set<String> rhs) {
        HashSet<String> merged = new HashSet<String>();
        merged.addAll(lhs);
        merged.addAll(rhs);
        return merged;
    }
}

