/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes;

import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandInfo {
    private final String command;
    private final CommandType pipeline;
    private final String raw;
    private final CommandType type;
    private final List<FieldProperties> metadata;

    public CommandInfo(JSONObject json) {
        this(json.getString("command"), CommandInfo.convertToCommandType(json.getString("pipeline")), json.optString("raw", ""), CommandInfo.convertToCommandType(json.getString("type")), CommandInfo.loadMetadata(json.getJSONArray("fields_and_properties")));
    }

    private CommandInfo(String command, CommandType type, String raw, CommandType pipeline, List<FieldProperties> metadata) {
        this.command = command;
        this.type = type;
        this.raw = raw;
        this.pipeline = pipeline;
        this.metadata = Collections.unmodifiableList(metadata);
    }

    private static CommandType convertToCommandType(String ct) {
        switch (ct) {
            case "SP_STREAM": 
            case "streaming": {
                return CommandType.SP_STREAM;
            }
            case "SP_STREAMREPORT": 
            case "reporting": {
                return CommandType.SP_STREAMREPORT;
            }
            case "SP_EVENTS": 
            case "events": {
                return CommandType.SP_EVENTS;
            }
            case "SP_REPORT": {
                return CommandType.SP_REPORT;
            }
            case "SP_STATEFUL": {
                return CommandType.SP_STATEFUL;
            }
            case "INTERNAL": {
                return CommandType.INTERNAL;
            }
        }
        return CommandType.UNKNOWN;
    }

    private static List<FieldProperties> loadMetadata(JSONArray fieldAndProperties) {
        if (fieldAndProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldProperties> metadata = new ArrayList<FieldProperties>();
        for (int i = 0; i < fieldAndProperties.length(); ++i) {
            JSONObject obj = fieldAndProperties.getJSONObject(i);
            metadata.add(i, CommandInfo.loadMetadata(obj));
        }
        return metadata;
    }

    private static FieldProperties loadMetadata(JSONObject fieldInfo) {
        String name = fieldInfo.getString("name");
        boolean modified = fieldInfo.optBoolean("getModified", false);
        boolean referenced = fieldInfo.optBoolean("getReferenced", false);
        boolean removed = fieldInfo.optBoolean("getRemoved", false);
        boolean filterable = fieldInfo.optBoolean("getFilterable", false);
        return new FieldProperties(name, modified, referenced, removed, filterable);
    }

    public String getCommand() {
        return this.command;
    }

    public CommandType getPipeline() {
        return this.pipeline;
    }

    public String getRaw() {
        return this.raw;
    }

    public CommandType getType() {
        return this.type;
    }

    public List<FieldProperties> getMetadata() {
        return this.metadata;
    }
}

