/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes;

import com.splunk.commons.ast.antlr.CompleteSPLParser;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.ast.nodes.CommandProperties;
import com.splunk.commons.ast.nodes.CommandSourceKind;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.ICommandProperties;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.AppendCommand;
import com.splunk.commons.ast.nodes.commands.ApplyCommand;
import com.splunk.commons.ast.nodes.commands.BinCommand;
import com.splunk.commons.ast.nodes.commands.Conditional;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.FitCommand;
import com.splunk.commons.ast.nodes.commands.GroupByCommand;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.IfCommand;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.IntoCommand;
import com.splunk.commons.ast.nodes.commands.IplocationCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.LookupCommand;
import com.splunk.commons.ast.nodes.commands.RegexCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.ReverseCommand;
import com.splunk.commons.ast.nodes.commands.RexCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SendalertCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.commons.ast.nodes.commands.TimechartCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.JoinType;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandNode
extends Node
implements ICommandProperties {
    private static final Logger logger = LoggerFactory.getLogger(CommandNode.class);
    protected static final CommandNode[] NO_SOURCE = new CommandNode[0];
    private final String commandName;
    private final CommandType commandType;
    private final CommandNode[] sources;
    private FieldProperties[] fieldsAndProperties;
    private final CommandSourceKind commandSourceKind;
    private final CommandProperties commandProperties;

    protected CommandNode(String commandName, CommandType commandType, FieldProperties[] fieldsAndProperties) {
        this(NO_SOURCE, commandName, commandType, fieldsAndProperties);
    }

    protected CommandNode(CommandNode source, String commandName, CommandType commandType, FieldProperties[] fieldsAndProperties) {
        this(new CommandNode[]{source}, commandName, commandType, fieldsAndProperties);
        if (source == null) {
            logger.error("source is null: command={}", (Object)commandName);
            throw new RuntimeException("CommandNode.source MUST not be null.");
        }
    }

    protected CommandNode(CommandNode[] sources, String commandName, CommandType commandType, FieldProperties[] fieldsAndProperties) {
        this.commandName = commandName;
        this.commandType = commandType;
        this.fieldsAndProperties = fieldsAndProperties;
        this.sources = sources == null ? NO_SOURCE : sources;
        this.commandSourceKind = CommandSourceKind.getFromSource(this.sources.length);
        this.commandProperties = new CommandProperties();
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public CommandNode[] getSources() {
        return this.sources;
    }

    public CommandNode setSources(CommandNode[] sources) {
        throw new RuntimeException("Command doesn't support setting sources.");
    }

    public CommandNode getSource() {
        if (this.getSources().length == 1) {
            return this.getSources()[0];
        }
        throw new RuntimeException("Command doesn't have exactly one Source.");
    }

    public CommandNode setSource(CommandNode source) {
        throw new RuntimeException("Command doesn't support setting the source.");
    }

    public boolean isSourceEmpty() {
        return this.sources.length == 0 || this.sources[0].equals(NO_SOURCE);
    }

    public boolean isMultiSourced() {
        return this.sources.length > 1;
    }

    public FieldProperties[] getFieldPropertiesArray() {
        return this.fieldsAndProperties;
    }

    protected void setFieldPropertiesArray(FieldProperties[] fieldsAndProperties) {
        this.fieldsAndProperties = fieldsAndProperties;
    }

    public CommandType getPipeline() {
        if (this.commandType == CommandType.SP_REPORT || this.sources.length == 0) {
            return this.commandType;
        }
        HashSet<CommandType> set = new HashSet<CommandType>();
        set.add(this.commandType);
        for (CommandNode source : this.sources) {
            set.add(source.getPipeline());
        }
        return CommandNode.merge(set);
    }

    public CommandSourceKind getCommandSourceKind() {
        return this.commandSourceKind;
    }

    private static CommandType merge(Set<CommandType> commandTypes) {
        if (commandTypes.contains((Object)CommandType.SP_REPORT)) {
            return CommandType.SP_REPORT;
        }
        if (commandTypes.contains((Object)CommandType.SP_STREAMREPORT)) {
            return CommandType.SP_STREAMREPORT;
        }
        if (commandTypes.contains((Object)CommandType.SP_EVENTS)) {
            return CommandType.SP_EVENTS;
        }
        if (commandTypes.contains((Object)CommandType.SP_STATEFUL)) {
            return CommandType.SP_STATEFUL;
        }
        return CommandType.SP_STREAM;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public AppendCommand append(CommandNode subsearch) {
        return new AppendCommand(this, subsearch);
    }

    public BinCommand bin(String fieldName, String span) {
        return new BinCommand(this, new BinNode(new FieldNode(fieldName), new BinOptionsNode(SpanNode.getSpanNode(span))));
    }

    public BinCommand bin(BinNode binNode) {
        return new BinCommand(this, binNode);
    }

    public BinCommand bin(BinNode binNode, FieldNode newField) {
        return new BinCommand(this, binNode, newField);
    }

    public DedupCommand dedup(int limit) {
        return new DedupCommand(this, limit);
    }

    public DedupCommand dedup(int limit, FieldNode[] fields) {
        return new DedupCommand(this, limit, fields);
    }

    public IfCommand branch(Conditional[] branches) {
        return new IfCommand(this, branches);
    }

    public EvalCommand eval(AssignmentNode[] assignments) {
        return new EvalCommand(this, assignments);
    }

    public EvalCommand eval(String fieldName, TypeNode expression) {
        return new EvalCommand(this, new AssignmentNode(fieldName, expression).array());
    }

    public FieldsCommand fields(FieldNode[] fields, boolean removeFields) {
        return new FieldsCommand(this, fields, removeFields);
    }

    public FieldsCommand fields(FieldNode[] fields) {
        return this.fields(fields, false);
    }

    public FieldsCommand fields(String[] fields, boolean removeFields) {
        FieldNode[] fieldNodes = new FieldNode[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNodes[i] = new FieldNode(fields[i]);
        }
        return this.fields(fieldNodes, removeFields);
    }

    public FieldsCommand fields(String[] fields) {
        return this.fields(fields, false);
    }

    public GroupByCommand groupBy(FieldNode[] fields) {
        return new GroupByCommand(this, fields);
    }

    public HeadCommand head(int limit) {
        return new HeadCommand(this, limit);
    }

    public HeadCommand head(IWherePredicate predicate) {
        return new HeadCommand(this, predicate);
    }

    public HeadCommand head(int limit, IWherePredicate predicate, boolean keeplast, boolean nullIsMatch) {
        return new HeadCommand(this, limit, predicate, keeplast, nullIsMatch);
    }

    public IfCommand ifcommand(Conditional[] conditionals) {
        return new IfCommand(this, conditionals);
    }

    public InputlookupCommand inputlookup(String name) {
        return new InputlookupCommand(this, name);
    }

    public InputlookupCommand inputlookup(String name, ISearchPredicate predicate) {
        return new InputlookupCommand(this, name, predicate);
    }

    public IntoCommand into(Dataset dataset) {
        return new IntoCommand(this, dataset, null);
    }

    public IntoCommand into(Dataset dataset, IntoCommand.IntoMode mode) {
        return new IntoCommand(this, dataset, mode);
    }

    public IplocationCommand iplocation(String ipField) {
        return new IplocationCommand(this, ipField);
    }

    public IplocationCommand iplocation(String ipField, String prefix, String lang, boolean allFields) {
        return new IplocationCommand(this, ipField, prefix, lang, allFields);
    }

    public JobPartitionerCommand jobpartitioner(String partitionName) {
        return new JobPartitionerCommand(this, partitionName, null, true);
    }

    public JobPartitionerCommand jobpartitioner(String partitionName, FieldNode[] byFields, boolean isiInternal) {
        return new JobPartitionerCommand(this, partitionName, byFields, isiInternal);
    }

    public JobPartitionerCommand jobpartitioner(String partitionName, boolean isiInternal) {
        return new JobPartitionerCommand(this, partitionName, null, isiInternal);
    }

    public JoinCommand join(CommandNode rhs) {
        return new JoinCommand(this, rhs, new String[0]);
    }

    public JoinCommand join(CommandNode rhs, String joinField) {
        return new JoinCommand(this, rhs, new String[]{joinField});
    }

    public JoinCommand join(CommandNode rhs, String[] joinFields, JoinType joinType, boolean usetime, boolean earlier, boolean overwrite, int max) {
        return new JoinCommand(this, rhs, joinFields, joinType, usetime, earlier, overwrite, max);
    }

    public JoinCommand join(CommandNode rhs, String[] joinFields, JoinType joinType, String lhsOutputPrefix, String rhsOutputPrefix) {
        return new JoinCommand(this, rhs, joinFields, joinType, lhsOutputPrefix, rhsOutputPrefix);
    }

    public JoinCommand join(CommandNode rhs, String lhsField, String rhsField, String lhsOutputPrefix, String rhsOutputPrefix) {
        return new JoinCommand(this, rhs, new JoinNode[]{new JoinNode(lhsField, rhsField)}, lhsOutputPrefix, rhsOutputPrefix);
    }

    public LookupCommand lookup(String lookup, String rhsJoinKey) {
        return new LookupCommand(this, lookup, rhsJoinKey);
    }

    public LookupCommand lookup(String lookup, JoinNode[] joinKeys, LookupCommand.LookupMode mode, JoinNode[] selections) {
        return new LookupCommand(this, lookup, joinKeys, mode, selections);
    }

    public LookupCommand lookup(String lookup, JoinNode[] joinKeys, LookupCommand.LookupMode mode, JoinNode[] selections, boolean update, boolean local, boolean required, boolean forceLookup) {
        return new LookupCommand(this, lookup, joinKeys, mode, selections, update, local, required, forceLookup);
    }

    public RegexCommand regex(String regex) {
        return this.regex("_raw", Operator.EQUAL, regex);
    }

    public RegexCommand regex(String fieldName, Operator operator, String regex) {
        return new RegexCommand(this, fieldName, operator, regex);
    }

    public RenameCommand rename(RenameNode[] renames) {
        return new RenameCommand(this, renames);
    }

    public ReverseCommand reverse() {
        return new ReverseCommand(this);
    }

    public RexCommand rex(String regex, FieldNode field) {
        return RexCommand.rex(this, regex, field);
    }

    public RexCommand rex_in_sedmode(String sed, FieldNode field) {
        return RexCommand.sed(this, sed, field);
    }

    public SearchCommand searchAgain(IPredicate predicate) {
        return new SearchCommand(this, predicate);
    }

    public SendalertCommand sendalert(StringNode name, StringNode resultLink, StringNode resultsPath, ParamNode[] paramNodes) {
        return new SendalertCommand(this, name, resultLink, resultsPath, paramNodes);
    }

    public ApplyCommand apply(StringNode modelname, FieldNode field) {
        return new ApplyCommand(this, modelname, field);
    }

    public FitCommand fit(StringNode algorithm, FieldNode targetfield, FieldNode[] featuredfields, ParamNode[] params, StringNode modelname, FieldNode outputfield) {
        return new FitCommand(this, algorithm, targetfield, featuredfields, params, modelname, outputfield);
    }

    public SortCommand sort(IOrdering[] by, int count) {
        return new SortCommand(this, by, count);
    }

    public StatsCommand stats(AggregateNode[] aggregates) {
        return new StatsCommand(this, Arrays.asList(aggregates));
    }

    public StatsCommand stats(AggregateNode[] aggregates, IGroupBy[] byFields) {
        return new StatsCommand(this, Arrays.asList(aggregates), Arrays.asList(byFields));
    }

    public TableCommand table(FieldNode[] fields) {
        return new TableCommand(this, fields);
    }

    public TailCommand tail(int limit) {
        return new TailCommand(this, limit);
    }

    public UnionCommand union(CommandNode rhs) {
        return new UnionCommand(this, rhs);
    }

    public UnknownCommand unknown(String commandName, String arguments, CommandType type, FieldProperties[] metadata) {
        return new UnknownCommand(new CommandNode[]{this}, commandName, arguments, type, metadata);
    }

    public WhereCommand where(IPredicate predicate) {
        return new WhereCommand(this, predicate);
    }

    public WhereCommand where(String expression) {
        return new WhereCommand(this, (IPredicate)((Object)new CompleteSPLParser().parseWherePredicate(expression)));
    }

    public TimechartCommand timechart(AggregateNode ... aggregates) {
        return new TimechartCommand(this, aggregates);
    }

    public TimechartCommand timechart(BinNode splitBy, AggregateNode ... aggregates) {
        return new TimechartCommand(this, splitBy, aggregates);
    }

    public TimechartCommand timechart(BinOptionsNode binOptions, AggregateNode ... aggregates) {
        return new TimechartCommand(this, binOptions, aggregates);
    }

    public TimechartCommand timechart(BinOptionsNode binOptions, BinNode splitBy, AggregateNode ... aggregates) {
        return new TimechartCommand(this, binOptions, splitBy, aggregates);
    }

    public boolean isSingleSourced() {
        return this.getSources().length == 1;
    }

    private Set<String> getAvailableSourceFields() {
        boolean cleanslate = false;
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getName().equals("*") || !fp.getRemoved()) continue;
            cleanslate = true;
            break;
        }
        if (cleanslate) {
            return new HashSet<String>();
        }
        if (this.getSources().length == 0) {
            return new HashSet<String>();
        }
        if (this.getSources().length == 1) {
            return this.getSource().getAvailableFields();
        }
        HashSet<String> merged = new HashSet<String>();
        for (CommandNode source : this.getSources()) {
            Set<String> unmerged = source.getAvailableFields();
            merged.addAll(unmerged);
        }
        return merged;
    }

    public Set<String> getAvailableFields() {
        Set<String> fields = this.getAvailableSourceFields();
        boolean mustBeModified = false;
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            String remove = fp.getName();
            if (!fp.getRemoved()) continue;
            if (remove.equals("*")) {
                fields.clear();
                break;
            }
            if (remove.contains("*")) {
                HashSet<String> matches = new HashSet<String>();
                String regex = remove.replace("*", "(.)*");
                for (String existing : fields) {
                    if (!existing.matches(regex)) continue;
                    matches.add(existing);
                }
                for (String match : matches) {
                    fields.remove(match);
                }
                continue;
            }
            fields.remove(remove);
        }
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (fp.getRemoved() || !fp.getModified()) continue;
            fields.add(fp.getName());
        }
        return fields;
    }

    public FieldsAndProperties getFieldsAndProperties() {
        return new FieldsAndProperties(this.getFieldPropertiesArray());
    }

    @Override
    public boolean supportsRealtime() {
        return this.commandProperties.supportsRealtime();
    }

    @Override
    public boolean shouldShortCircuit() {
        return this.commandProperties.shouldShortCircuit();
    }

    @Override
    public boolean isGenerating() {
        return this.getSources().length == 0;
    }

    @Override
    public boolean allowRemoteTimeline() {
        return this.commandProperties.allowRemoteTimeline();
    }

    @Override
    public boolean isOrderSensitive() {
        return this.commandProperties.isOrderSensitive();
    }

    @Override
    public boolean isCommandExternal() {
        return this.commandProperties.isCommandExternal();
    }

    @Override
    public boolean requiresTimeDescOrder() {
        return this.commandProperties.requiresTimeDescOrder();
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        this.commandProperties.setRequiredFields(requiredFields);
    }

    @Override
    public boolean requiresPrevStreaming() {
        return this.commandProperties.requiresPrevStreaming();
    }

    @Override
    public boolean startPaused() {
        return this.commandProperties.startPaused();
    }

    @Override
    public void setOrderInfo(CommandOrderInfo commandOrderInfo) {
        if (this.commandType.ordinal() > CommandType.SP_EVENTS.ordinal()) {
            commandOrderInfo.reset();
        }
    }

    @Override
    public void setColumnOrder(List<String> columnOrder) {
    }

    public String toString() {
        SplFormatter formatter = new SplFormatter();
        return this.accept(formatter);
    }

    public Dataset getDataset() {
        return new TransientDataset(this);
    }
}

