/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class ApplyCommand
extends CommandNode {
    private final StringNode modelname;
    private final FieldNode resultfield;

    public ApplyCommand(CommandNode source, StringNode modelname, FieldNode fieldresult) {
        super(source, "apply", CommandType.SP_REPORT, new FieldsAndProperties().array());
        this.modelname = modelname;
        this.resultfield = fieldresult;
    }

    public ApplyCommand(CommandNode source, StringNode modelname) {
        this(source, modelname, null);
    }

    private StringNode getModelName() {
        return this.modelname;
    }

    private FieldNode getOutputField() {
        return this.resultfield;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new ApplyCommand(source, this.modelname, this.resultfield);
    }

    public String getSPL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.modelname.getValue());
        if (this.resultfield != null && this.resultfield.getFieldName() != "") {
            buffer.append(" as ").append(this.resultfield.getFieldName());
        }
        return buffer.toString();
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }
}

