/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.visitors.NodeVisitor;

public class DatamodelCommand
extends CommandNode {
    private final Dataset dataset;
    private final String datamodelName;
    private final String objectName;
    private final DatamodelSearchMode mode;
    private final String[] fieldNames;
    private final String spl;

    public DatamodelCommand(String datamodelName, String objectName, DatamodelSearchMode mode, String[] fieldNames, String spl) {
        super("datamodel", CommandType.SP_EVENTS, new FieldsAndProperties().datamodel(fieldNames).array());
        DatamodelCommand.assertParamNotNull(datamodelName, "datamodelName");
        DatamodelCommand.assertParamNotNull(objectName, "objectName");
        DatamodelCommand.assertParamMembersNotNull(fieldNames, "fieldNames");
        if (mode != DatamodelSearchMode.SEARCH && mode != DatamodelSearchMode.FLATTENED_SEARCH) {
            throw new IllegalArgumentException();
        }
        this.dataset = new Dataset("datamodel", datamodelName + '.' + objectName);
        this.datamodelName = datamodelName;
        this.objectName = objectName;
        this.fieldNames = fieldNames;
        this.mode = mode;
        this.spl = spl == null ? "" : spl;
    }

    public DatamodelCommand(String datamodelName, String datasetName, DatamodelSearchMode mode) {
        this(datamodelName, datasetName, mode, new String[]{"*"}, null);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public String getDatamodelName() {
        return this.datamodelName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public DatamodelSearchMode getMode() {
        return this.mode;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String getSpl() {
        return this.spl;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static enum DatamodelSearchMode {
        SEARCH,
        FLATTENED_SEARCH,
        ACCELERATION_SEARCH,
        METADATA;


        public String toString() {
            switch (this) {
                case SEARCH: {
                    return "search";
                }
                case FLATTENED_SEARCH: {
                    return "flat";
                }
                case ACCELERATION_SEARCH: {
                    throw new UnsupportedOperationException();
                }
                case METADATA: {
                    return "";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

