/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.providers.OpenMode;
import com.splunk.commons.visitors.NodeVisitor;

public class IntoCommand
extends CommandNode {
    private final Dataset target;
    private final IntoMode mode;

    public IntoCommand(CommandNode source, Dataset target, IntoMode mode) {
        super(source, "into", CommandType.SP_STREAM, new FieldProperties[0]);
        IntoCommand.assertNotNull("The 'into' command requires a source.", source);
        IntoCommand.assertNotNull("The 'into' command requires a target.", target);
        this.target = target;
        this.mode = mode;
    }

    public Dataset getTarget() {
        return this.target;
    }

    public IntoMode getMode() {
        return this.mode;
    }

    @Override
    public Dataset getDataset() {
        return this.target;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static enum IntoMode {
        replace,
        append,
        delta;


        public OpenMode asOpenMode() {
            switch (this) {
                case replace: {
                    return OpenMode.UPDATE_AND_REPLACE;
                }
                case append: {
                    return OpenMode.UPDATE_AND_APPEND;
                }
                case delta: {
                    return OpenMode.UPDATE_AND_APPLY_DELTA;
                }
            }
            throw new IllegalStateException("Unexpected IntoMode detected.");
        }
    }
}

