/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.visitors.NodeVisitor;

public class IplocationCommand
extends CommandNode {
    public static final String DEFAULT_LANG = "";
    private final String ipField;
    private final String prefix;
    private final boolean allFields;
    private final String lang;

    public IplocationCommand(CommandNode source, String ipField) {
        this(source, ipField, DEFAULT_LANG, "en-US", false);
    }

    public IplocationCommand(CommandNode source, String ipField, String prefix, String lang, boolean allFields) {
        super(source, "iplocation", CommandType.SP_STREAM, new FieldsAndProperties().iplocation(ipField, prefix, allFields).array());
        IplocationCommand.assertParamNotNull(ipField, "ipField");
        IplocationCommand.assertParamNotNull(prefix, "prefix");
        IplocationCommand.assertParamNotNull(lang, "lang");
        this.ipField = ipField;
        this.prefix = prefix;
        this.lang = lang;
        this.allFields = allFields;
    }

    public String getIpField() {
        return this.ipField;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isAllFields() {
        return this.allFields;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new IplocationCommand(source, this.ipField, this.prefix, this.lang, this.allFields);
    }
}

