/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class JobPartitionerCommand
extends CommandNode {
    private final String partitionName;
    private final boolean isInternal;
    private final FieldNode[] byFields;

    public String getJobPartitionName() {
        return this.partitionName;
    }

    public boolean isInternalJob() {
        return this.isInternal;
    }

    public FieldNode[] getByFields() {
        return this.byFields;
    }

    public JobPartitionerCommand(CommandNode node, String partitionName) {
        this(node, partitionName, null, true);
    }

    public JobPartitionerCommand(CommandNode node, String partitionName, FieldNode[] byFields) {
        this(node, partitionName, byFields, true);
    }

    public JobPartitionerCommand(CommandNode source, String partitionName, FieldNode[] byFields, boolean isInternal) {
        super(source, "jobpartition", CommandType.INTERNAL, FieldsAndProperties.DEFAULT);
        this.partitionName = partitionName;
        this.isInternal = isInternal;
        this.byFields = byFields == null || byFields.length == 0 ? null : byFields;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new JobPartitionerCommand(source, this.partitionName, this.byFields, this.isInternal);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
    }
}

