/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.visitors.NodeVisitor;

public class LookupCommand
extends CommandNode {
    public static final boolean DEFAULT_LOCAL = false;
    private final JoinNode[] joinKeys;
    private final JoinNode[] selections;
    private final LookupMode mode;
    private final boolean update;
    private final boolean local;
    private final boolean required;
    private final boolean forceIndexed;
    private final Dataset dataset;

    public LookupCommand(CommandNode source, String lookupName, String rhsJoinKey) {
        this(source, lookupName, new JoinNode(rhsJoinKey).array(), LookupMode.ALL, null, false, false, true, false);
    }

    public LookupCommand(CommandNode source, String lookupName, JoinNode[] joinKeys, LookupMode mode, JoinNode[] selections) {
        this(source, lookupName, joinKeys, mode, selections, false, false, true, false);
    }

    public LookupCommand(CommandNode source, String lookupName, JoinNode[] joinKeys, LookupMode mode, JoinNode[] selections, boolean update, boolean local) {
        this(source, lookupName, joinKeys, mode, selections, update, local, true, false);
    }

    public LookupCommand(CommandNode source, String lookupName, JoinNode[] joinKeys, LookupMode mode, JoinNode[] selections, boolean update, boolean local, boolean required, boolean forceIndexed) {
        super(source, "lookup", CommandType.SP_STREAM, new FieldsAndProperties().lookup(joinKeys, selections).array());
        LookupCommand.assertParamMembersNotNull(joinKeys, "joinKeys");
        LookupCommand.assertParamNotNull(lookupName, "lookupName");
        if (mode != LookupMode.ALL) {
            LookupCommand.assertParamMembersNotNull(selections, "selections");
        }
        this.dataset = new Dataset("lookup", lookupName);
        this.joinKeys = joinKeys;
        this.mode = mode;
        this.selections = selections;
        this.update = update;
        this.local = local;
        this.required = required;
        this.forceIndexed = forceIndexed;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public String getLookupName() {
        return this.dataset.getName();
    }

    public JoinNode[] getJoinKeys() {
        return this.joinKeys;
    }

    public LookupMode getMode() {
        return this.mode;
    }

    public JoinNode[] getSelections() {
        return this.selections;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isForceIndexed() {
        return this.forceIndexed;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new LookupCommand(source, this.getLookupName(), this.joinKeys, this.mode, this.selections, this.update, this.local, this.required, this.forceIndexed);
    }

    public static enum LookupMode {
        ALL,
        OUTPUT,
        OUTPUTNEW;

    }
}

