/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IFilteringCommand;
import com.splunk.commons.ast.nodes.IGroupingCommand;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.util.SafeArgs;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class McatalogCommand
extends CommandNode
implements IGroupingCommand,
IFilteringCommand {
    public static final boolean DEFAULT_PRESTATS = false;
    public static final boolean DEFAULT_APPEND = false;
    private final AggregateNode[] values;
    private final IWherePredicate where;
    private final IGroupBy[] groupByNodes;
    private final BooleanNode prestatsNode;
    private final BooleanNode appendNode;

    public McatalogCommand(AggregateNode[] values) {
        this(values, null);
    }

    public McatalogCommand(AggregateNode[] values, IWherePredicate predicate) {
        this(values, predicate, null, false, false);
    }

    public McatalogCommand(AggregateNode[] values, IWherePredicate predicate, IGroupBy[] groupByNodes, boolean prestats, boolean append) {
        this(values, predicate, groupByNodes, BooleanNode.load(prestats), BooleanNode.load(append));
    }

    public McatalogCommand(AggregateNode[] values, IWherePredicate predicate, IGroupBy[] groupByNodes, BooleanNode prestatsNode, BooleanNode appendNode) {
        super("mcatalog", CommandType.SP_STREAM, new FieldsAndProperties().aggregate(values).where(predicate).by(groupByNodes).array());
        this.values = SafeArgs.valueIsNotNull(values, "| mcatalog must have atleast one values() aggregate");
        this.where = predicate;
        this.groupByNodes = groupByNodes;
        this.prestatsNode = prestatsNode;
        this.appendNode = appendNode;
        for (AggregateNode node : values) {
            if (node.getFunction() == AggregateFunction.VALUES) continue;
            throw new IllegalArgumentException("Invalid AggregateFunction:\"" + (Object)((Object)node.getFunction()) + "\" provided, mcatalog can only accept \"values\" aggregate function.");
        }
    }

    public BooleanNode getPrestatsNode() {
        return this.prestatsNode;
    }

    public BooleanNode getAppendNode() {
        return this.appendNode;
    }

    public AggregateNode[] getAggregateNodes() {
        return this.values;
    }

    @Override
    public List<IGroupBy> getByFields() {
        return this.groupByNodes != null ? Arrays.asList(this.groupByNodes) : null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }

    @Override
    public IPredicate getPredicate() {
        return this.where;
    }

    @Override
    public CommandNode getCommand() {
        return this;
    }
}

