/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class SortCommand
extends CommandNode {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_COUNT = 10000;
    private final IOrdering[] by;
    private final int count;

    public SortCommand(CommandNode source, IOrdering[] by) {
        this(source, by, 10000);
    }

    public SortCommand(CommandNode source, IOrdering[] by, int count) {
        super(source, "sort", CommandType.SP_EVENTS, new FieldsAndProperties().orderby(by).array());
        SortCommand.assertParamMembersNotNull(by, "by");
        SortCommand.assertTrue("The count must be a non-negative number.", count >= 0);
        this.by = by;
        this.count = count;
    }

    public IOrdering[] getBy() {
        return this.by;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new SortCommand(source, this.by, this.count);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }

    @Override
    public void setOrderInfo(CommandOrderInfo commandOrderInfo) {
        if (this.by.length > 0) {
            commandOrderInfo.setOrderField(this.by[0].getField().getFieldName());
            commandOrderInfo.setOrder(this.by[0].getSortOrder() == SortOrder.ASC);
        }
    }
}

