/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IGroupingCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class StatsCommand
extends CommandNode
implements IGroupingCommand {
    public static final int DEFAULT_PARTITIONS = 1;
    public static final boolean DEFAULT_ALLNUMS = false;
    public static final String DEFAULT_DELIM = " ";
    public static final String DEFAULT_SPAN_TIMEFIELD = "_time";
    public static final boolean DEFAULT_PRESTATS_MODE = false;
    public static final boolean DEFAULT_PRECOMPUTED_MODE = false;
    private static final List<AggregateNode> defaultAggregates = Collections.singletonList(new AggregateNode(AggregateFunction.ALL, new FieldNode("*")));
    private final List<IGroupBy> byFields;
    private final List<AggregateNode> aggregates;
    private final NumberNode partitions;
    private final BooleanNode allnum;
    private final StringNode delim;
    private final boolean prestatsMode;
    private final boolean preComputed;

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates) {
        this(source, aggregates, null);
    }

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates, List<IGroupBy> byFields) {
        this(source, aggregates, byFields, null, null, null, false);
    }

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates, List<IGroupBy> byFields, boolean prestatsMode) {
        this(source, aggregates, byFields, null, null, null, prestatsMode);
    }

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates, List<IGroupBy> byFields, int partitions, boolean allnum, String delim) {
        this(source, aggregates, byFields, partitions, allnum, delim, false);
    }

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates, List<IGroupBy> byFields, int partitions, boolean allnum, String delim, boolean prestatsMode) {
        this(source, aggregates, byFields, new NumberNode(partitions), BooleanNode.load(allnum), new StringNode(delim), prestatsMode);
    }

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates, List<IGroupBy> byFields, NumberNode partitions, BooleanNode allnum, StringNode delim, boolean prestatsMode) {
        this(source, aggregates, byFields, partitions, allnum, delim, prestatsMode, new FieldsAndProperties().field("*", false, false, true, false).aggregate(aggregates != null ? aggregates.toArray(new AggregateNode[0]) : null).by(byFields != null ? byFields.toArray(new IGroupBy[0]) : null).array(), false);
    }

    public StatsCommand(CommandNode source, List<AggregateNode> aggregates, List<IGroupBy> byFields, NumberNode partitions, BooleanNode allnum, StringNode delim, boolean prestatsMode, FieldProperties[] fieldsPropertiesArray, boolean preComputed) {
        super(source, "stats", prestatsMode ? CommandType.SP_STREAM : CommandType.SP_STREAMREPORT, fieldsPropertiesArray);
        this.aggregates = Collections.unmodifiableList(aggregates == null || aggregates.isEmpty() ? defaultAggregates : aggregates);
        this.byFields = byFields == null ? Collections.emptyList() : Collections.unmodifiableList(byFields);
        this.partitions = partitions;
        this.allnum = allnum;
        this.delim = delim;
        this.prestatsMode = prestatsMode;
        this.preComputed = preComputed;
    }

    @Override
    public List<IGroupBy> getByFields() {
        return this.byFields;
    }

    public List<AggregateNode> getAggregates() {
        return this.aggregates;
    }

    public NumberNode getPartitions() {
        return this.partitions;
    }

    public BooleanNode getAllnum() {
        return this.allnum;
    }

    public StringNode getDelim() {
        return this.delim;
    }

    public boolean isPrestatsMode() {
        return this.prestatsMode;
    }

    public boolean isPreComputed() {
        return this.preComputed;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new StatsCommand(source, this.aggregates, this.byFields, this.partitions, this.allnum, this.delim, this.prestatsMode, this.getFieldPropertiesArray(), this.preComputed);
    }

    public CommandNode convertToPrestats(CommandNode source) {
        return new StatsCommand(source, this.aggregates, this.byFields, this.partitions, this.allnum, this.delim, true, this.getFieldPropertiesArray(), this.preComputed);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        requiredFields.remove("*");
        for (FieldProperties fieldProperties : this.getFieldPropertiesArray()) {
            if (!fieldProperties.getReferenced()) continue;
            requiredFields.add(fieldProperties.getName());
        }
        if (this.prestatsMode) {
            requiredFields.add("prestats_reserved_*");
            requiredFields.add("psrsvd_*");
        }
    }

    @Override
    public void setColumnOrder(List<String> columnOrder) {
        if (this.byFields != null) {
            for (IGroupBy groupBy : this.byFields) {
                columnOrder.add(groupBy.getByName());
            }
        }
        if (this.aggregates != null) {
            for (AggregateNode aggregateNode : this.aggregates) {
                columnOrder.add(aggregateNode.getAsName());
            }
        }
    }
}

