/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IExpression;
import com.splunk.commons.ast.nodes.IGroupingCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.EvalAggregateNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class TimechartCommand
extends CommandNode
implements IGroupingCommand {
    private final AggregateNode[] aggregates;
    private final StringNode sep;
    private final StringNode format;
    private final BooleanNode partial;
    private final BooleanNode cont;
    private final BooleanNode fixedRange;
    private final NumberNode limit;
    private final StringNode agg;
    private final IGroupBy[] byFields;

    public TimechartCommand(CommandNode source, AggregateNode ... aggregates) {
        this(source, (IGroupBy)null, aggregates);
    }

    public TimechartCommand(CommandNode source, IGroupBy splitBy, AggregateNode ... aggregates) {
        this(source, null, null, null, null, null, null, null, null, splitBy, aggregates);
    }

    public TimechartCommand(CommandNode source, BinOptionsNode binOptions, AggregateNode ... aggregates) {
        this(source, null, null, null, null, null, null, null, binOptions, null, aggregates);
    }

    public TimechartCommand(CommandNode source, BinOptionsNode binOptions, IGroupBy splitBy, AggregateNode ... aggregates) {
        this(source, null, null, null, null, null, null, null, binOptions, splitBy, aggregates);
    }

    public TimechartCommand(CommandNode source, StringNode sep, StringNode format, BooleanNode partial, BooleanNode cont, BooleanNode fixedRange, NumberNode limit, StringNode agg, IGroupBy[] byFields, AggregateNode ... aggregates) {
        super(source, "timechart", CommandType.SP_STREAMREPORT, new FieldsAndProperties().timechart(sep, format, byFields, aggregates).array());
        this.sep = sep;
        this.format = format;
        this.partial = partial;
        this.cont = cont;
        this.fixedRange = fixedRange;
        this.limit = limit;
        this.agg = agg;
        if (aggregates == null || aggregates.length == 0) {
            throw new IllegalArgumentException("timechart requires at least one aggregation function. No aggregation is found!");
        }
        this.aggregates = aggregates;
        ArrayList<IGroupBy> tmp = new ArrayList<IGroupBy>();
        for (IGroupBy iGroupBy : byFields) {
            if (iGroupBy == null) continue;
            tmp.add(iGroupBy);
        }
        this.byFields = tmp.toArray(new IGroupBy[0]);
        for (IExpression iExpression : aggregates) {
            if (!(iExpression instanceof EvalAggregateNode) || !((AggregateNode)iExpression).hasDefaultAsName() || this.getSplitBy() != null && aggregates.length <= 1) continue;
            throw new IllegalArgumentException("eval expression '" + ((AggregateNode)iExpression).getEvalFunc() + "' must be renamed with the AS field.");
        }
        if (byFields == null || byFields.length == 0 || byFields.length > 2) {
            throw new IllegalStateException("No group by field found.");
        }
        if (!(byFields[0] instanceof BinNode) || !"_time".equals(((BinNode)byFields[0]).getField().getFieldName())) {
            throw new IllegalStateException("_time must be the first group by field to render search results properly.");
        }
    }

    public TimechartCommand(CommandNode source, StringNode sep, StringNode format, BooleanNode partial, BooleanNode cont, BooleanNode fixedRange, NumberNode limit, StringNode agg, BinOptionsNode binOptions, IGroupBy splitBy, AggregateNode ... aggregates) {
        this(source, sep, format, partial, cont, fixedRange, limit, agg, new IGroupBy[]{BinNode.getDefaultTimeBin(binOptions), splitBy}, aggregates);
    }

    public StringNode getSep() {
        return this.sep;
    }

    public StringNode getFormat() {
        return this.format;
    }

    public BooleanNode getPartial() {
        return this.partial;
    }

    public BooleanNode getCont() {
        return this.cont;
    }

    public BooleanNode getFixedRange() {
        return this.fixedRange;
    }

    public NumberNode getLimit() {
        return this.limit;
    }

    public StringNode getAgg() {
        return this.agg;
    }

    public AggregateNode[] getAggregates() {
        return this.aggregates;
    }

    public BinOptionsNode getBinOptions() {
        return ((BinNode)this.byFields[0]).getBinOptions();
    }

    public IGroupBy getSplitBy() {
        return this.byFields.length != 2 ? null : this.byFields[1];
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<IGroupBy> getByFields() {
        return Arrays.asList(this.byFields);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        requiredFields.remove("*");
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }

    @Override
    public void setColumnOrder(List<String> columnOrder) {
        if (this.byFields != null) {
            for (int i = 0; i < this.byFields.length; ++i) {
                columnOrder.add(this.byFields[i].getByName());
                columnOrder.add(",");
            }
        }
        if (this.aggregates != null) {
            for (AggregateNode ag : this.aggregates) {
                columnOrder.add(ag.getAsName());
            }
        }
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new TimechartCommand(source, this.sep, this.format, this.partial, this.cont, this.fixedRange, this.limit, this.agg, this.byFields, this.aggregates);
    }
}

