/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;

public class AggregateNode
extends TypeNode
implements ISelection {
    final AggregateFunction function;
    final FieldNode field;
    final FieldNode asField;
    private final boolean asFieldDefaulted;
    private final FieldNode wcAsField;
    private final FunctionNode evalFunc;

    public AggregateNode(AggregateFunction function, FieldNode field, FieldNode asField, FieldNode wcAsField, FunctionNode evalFunc) {
        super("aggregate");
        this.function = function;
        this.field = field;
        this.evalFunc = evalFunc;
        if (asField != null) {
            this.asField = asField;
            this.asFieldDefaulted = evalFunc != null ? asField.equals(this.getDefaultAsField()) : this.isAsFieldDefaulted();
        } else {
            this.asField = this.getDefaultAsField();
            this.asFieldDefaulted = true;
        }
        this.wcAsField = wcAsField != null ? wcAsField : asField;
    }

    private boolean isAsFieldDefaulted() {
        FieldNode targetDefaultAsField = this.getDefaultAsField();
        String inputAsFieldName = this.asField.toString();
        FieldNode derivedDefaultAsField = null;
        if (inputAsFieldName.endsWith(")'")) {
            int fieldNameIdx = inputAsFieldName.indexOf("(");
            if (fieldNameIdx > 0) {
                String functionCandidate = inputAsFieldName.substring(1, fieldNameIdx);
                if (this.function.toString().equals(functionCandidate)) {
                    String fieldNameCandidate = inputAsFieldName.substring(fieldNameIdx + 1, inputAsFieldName.length() - 2);
                    derivedDefaultAsField = AggregateNode.createDefaultAsField(this.function, new FieldNode(fieldNameCandidate));
                }
            }
            return targetDefaultAsField.equals(derivedDefaultAsField);
        }
        return targetDefaultAsField.equals(this.asField);
    }

    public AggregateNode(AggregateFunction function, FieldNode field) {
        this(function, field, null, null, null);
    }

    public AggregateNode(AggregateFunction function, FieldNode field, String asName) {
        this(function, field, new FieldNode(asName), null, null);
    }

    private AggregateNode(AggregateFunction function, FieldNode field, String asName, String wcAsName) {
        this(function, field, new FieldNode(asName), new FieldNode(wcAsName), null);
    }

    public AggregateNode(AggregateFunction function, String fieldName, String asName) {
        this(function, new FieldNode(fieldName), asName);
    }

    public AggregateNode(AggregateFunction function, String fieldName, String asName, String wcAsName) {
        this(function, new FieldNode(fieldName), asName, wcAsName);
    }

    public AggregateNode(AggregateFunction function, FunctionNode evalFunc, String asName) {
        this(function, null, new FieldNode(asName), null, evalFunc);
    }

    public AggregateNode(AggregateFunction function, String fieldName) {
        this(function, new FieldNode(fieldName));
    }

    public static FieldNode createDefaultAsField(AggregateFunction function, FieldNode field) {
        String fieldName = "";
        if (field != null) {
            fieldName = field.toString();
        }
        String asFieldName = fieldName.isEmpty() ? String.format("%1$s", function.toString()) : String.format("%1$s(%2$s)", function.toString(), fieldName);
        return new FieldNode(asFieldName);
    }

    public static FieldNode createDefaultAsField(AggregateFunction function, FunctionNode evalFunc) {
        String asFieldName = String.format("%1$s(%2$s)", function.toString(), evalFunc.toString());
        return new FieldNode(asFieldName);
    }

    public static String createDefaultName(AggregateFunction function, FieldNode field) {
        return AggregateNode.createDefaultAsField(function, field).getFieldName();
    }

    public static String createDefaultName(AggregateFunction function, FunctionNode evalFunc) {
        return AggregateNode.createDefaultAsField(function, evalFunc).getFieldName();
    }

    public FieldNode getDefaultAsField() {
        if (this.evalFunc != null) {
            return AggregateNode.createDefaultAsField(this.function, this.evalFunc);
        }
        return AggregateNode.createDefaultAsField(this.function, this.field);
    }

    public String getDefaultName() {
        FieldNode defaultField = this.asFieldDefaulted ? this.asField : this.getDefaultAsField();
        return defaultField.getFieldName();
    }

    public AggregateFunction getFunction() {
        return this.function;
    }

    public FieldNode getField() {
        return this.field;
    }

    public FieldNode getAsField() {
        return this.asField;
    }

    public FieldNode getWcAsField() {
        return this.wcAsField;
    }

    public String getAsName() {
        return this.asField.getFieldName();
    }

    public String getWcAsName() {
        return this.wcAsField.getFieldName();
    }

    public FunctionNode getEvalFunc() {
        return this.evalFunc;
    }

    @Override
    public TypeNode getTypeNode() {
        return this;
    }

    public boolean hasDefaultAsName() {
        return this.asFieldDefaulted;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public AggregateNodeArray and(AggregateNode aggregate) {
        return new AggregateNodeArray().and(this).and(aggregate);
    }

    public AggregateNodeArray and(AggregateFunction function, String fieldName) {
        return this.and(new AggregateNode(function, fieldName));
    }

    public AggregateNodeArray and(AggregateFunction function, String fieldName, String asField) {
        return this.and(new AggregateNode(function, fieldName, asField));
    }

    public AggregateNode[] array() {
        return new AggregateNode[]{this};
    }

    public final class AggregateNodeArray {
        private final ArrayList<AggregateNode> aggregates = new ArrayList();

        private AggregateNodeArray() {
        }

        public AggregateNodeArray and(AggregateNode field) {
            this.aggregates.add(field);
            return this;
        }

        public AggregateNodeArray and(AggregateFunction function, String fieldName) {
            return this.and(new AggregateNode(function, fieldName));
        }

        public AggregateNodeArray and(AggregateFunction function, String fieldName, String asField) {
            return this.and(new AggregateNode(function, fieldName, asField));
        }

        public AggregateNode[] array() {
            return this.aggregates.toArray(new AggregateNode[this.aggregates.size()]);
        }
    }
}

