/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.ASTConstants;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.Objects;

public class BinNode
extends FunctionNode
implements IGroupBy {
    private final FieldNode field;
    private final BinOptionsNode binOptions;

    public static BinNode getDefaultTimeBin(BinOptionsNode binOptions) {
        return new BinNode(ASTConstants.DEFAULT_TIME_FIELD, binOptions);
    }

    public BinNode(FieldNode field, BinOptionsNode binOptions) {
        super("bin", Objects.requireNonNull(field), binOptions);
        this.field = field;
        this.binOptions = binOptions;
    }

    public BinNode(FieldNode field) {
        this(field, null);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getByName() {
        return this.accept(new SplFormatter());
    }

    public SpanNode getSpan() {
        return this.binOptions == null ? null : this.binOptions.getSpan();
    }

    public FieldNode getField() {
        return this.field;
    }

    public BinOptionsNode getBinOptions() {
        return this.binOptions;
    }

    @Override
    public String toString() {
        return this.getByName();
    }
}

