/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.PredicateType;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;

public final class BooleanNode
extends TypeNode
implements IWherePredicate {
    public static final BooleanNode TRUE = new BooleanNode("true", Boolean.TRUE);
    public static final BooleanNode FALSE = new BooleanNode("false", Boolean.FALSE);
    private final String id;
    private final Boolean value;

    private BooleanNode(String id, Boolean value) {
        super("bool");
        this.id = id;
        this.value = value;
    }

    public static BooleanNode load(String id) {
        if (BooleanNode.TRUE.id.equalsIgnoreCase(id)) {
            return TRUE;
        }
        if (BooleanNode.FALSE.id.equalsIgnoreCase(id)) {
            return FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value: " + id);
    }

    public static BooleanNode load(boolean value) {
        return value ? TRUE : FALSE;
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.id;
    }

    @Override
    public TypeNode getTypeNode() {
        return this;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public PredicateType getPredicateType() {
        return PredicateType.WHERE;
    }

    @Override
    public IPredicate and(IPredicate predicate) {
        return Expression.and((IPredicate)this, predicate);
    }

    @Override
    public IPredicate or(IPredicate predicate) {
        return Expression.or((IPredicate)this, predicate);
    }

    @Override
    public IPredicate xor(IPredicate predicate) {
        return Expression.xor((IPredicate)this, predicate);
    }
}

