/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;

public class JoinNode
extends Node {
    private final FieldNode leftSide;
    private final FieldNode rightSide;

    public JoinNode(String key) {
        this(key, key);
    }

    public JoinNode(String leftSide, String rightSide) {
        JoinNode.assertParamNotNull(leftSide, "leftSide");
        JoinNode.assertParamNotNull(rightSide, "rightSide");
        this.leftSide = Expression.field(leftSide);
        this.rightSide = Expression.field(rightSide);
    }

    public FieldNode getLeftSide() {
        return this.leftSide;
    }

    public FieldNode getRightSide() {
        return this.rightSide;
    }

    public String getCommonFieldName() {
        JoinNode.assertTrue(this.leftSide.equals(this.rightSide));
        return this.leftSide.getFieldName();
    }

    public boolean requiresV2Join() {
        return !this.leftSide.equals(this.rightSide);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public JoinNodeArray and(String key) {
        return new JoinNodeArray().and(this).and(key);
    }

    public JoinNodeArray and(String lhs, String rhs) {
        return new JoinNodeArray().and(this).and(lhs, rhs);
    }

    public JoinNodeArray and(JoinNode join) {
        return new JoinNodeArray().and(this).and(join);
    }

    public JoinNode[] array() {
        return new JoinNode[]{this};
    }

    public static final class JoinNodeArray {
        private final ArrayList<JoinNode> joins = new ArrayList();

        private JoinNodeArray() {
        }

        private JoinNodeArray and(String key) {
            this.joins.add(new JoinNode(key));
            return this;
        }

        private JoinNodeArray and(String lhs, String rhs) {
            this.joins.add(new JoinNode(lhs, rhs));
            return this;
        }

        private JoinNodeArray and(JoinNode join) {
            this.joins.add(join);
            return this;
        }

        public JoinNode[] array() {
            return this.joins.toArray(new JoinNode[0]);
        }
    }
}

