/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.Cardinality;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.IDatasetSource;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;

public class NavigationNode
extends TypeNode
implements IDatasetSource {
    private final Cardinality cardinality;
    private final IDatasetSource source;
    private final String name;

    public NavigationNode(String name) {
        super("navigation");
        this.name = name;
        this.cardinality = Cardinality.UNKNOWN;
        this.source = null;
    }

    public NavigationNode(String name, Cardinality cardinality) {
        super("navigation");
        this.name = name;
        this.cardinality = cardinality;
        this.source = null;
    }

    public NavigationNode(IDatasetSource source, String name) {
        this(source, name, Cardinality.UNKNOWN);
    }

    public NavigationNode(IDatasetSource source, String name, Cardinality cardinality) {
        super("navigation");
        this.name = name;
        this.cardinality = cardinality;
        this.source = source;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public IDatasetSource getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public BooleanFunctionNode any(IWherePredicate predicate) {
        return FunctionNode.any(this, predicate);
    }

    public BooleanFunctionNode all(IWherePredicate predicate) {
        return FunctionNode.all(this, predicate);
    }

    public FieldNode field(String name) {
        return Expression.field(this, name);
    }

    public NavigationNode navigate(String name) {
        return Expression.navigation(this, name);
    }

    public NavigationNode navigate(String name, Cardinality cardinality) {
        return Expression.navigation(this, name, cardinality);
    }
}

