/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.text.DecimalFormat;

public class NumberNode
extends TypeNode {
    private final Object value;

    public NumberNode(Number number) {
        super("number");
        this.value = number;
    }

    public NumberNode(double number) {
        super("number");
        this.value = number;
    }

    public NumberNode(float number) {
        super("number");
        this.value = Float.valueOf(number);
    }

    public NumberNode(int number) {
        super("number");
        this.value = number;
    }

    public NumberNode(long number) {
        super("number");
        this.value = number;
    }

    public String toString() {
        if (Double.class.isInstance(this.value)) {
            DecimalFormat df = new DecimalFormat("#");
            df.setMinimumIntegerDigits(1);
            df.setMinimumFractionDigits(1);
            df.setMaximumFractionDigits(8);
            return df.format(this.value);
        }
        if (Long.class.isInstance(this.value)) {
            return ((Long)this.value).toString();
        }
        if (Float.class.isInstance(this.value)) {
            return this.value.toString();
        }
        if (Integer.class.isInstance(this.value)) {
            return ((Integer)this.value).toString();
        }
        return this.value.toString();
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Object getValue() {
        return this.value;
    }
}

