/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.visitors.NodeVisitor;

public class ParamNode
extends Node {
    private final String paramName;
    private final String paramValue;
    private final boolean withparam;

    public ParamNode(String name, String value, boolean withparam) {
        this.paramName = name;
        this.paramValue = withparam ? value.replaceAll("^\"|\"$", "") : value;
        this.withparam = withparam;
    }

    public ParamNode(String name, String value) {
        this(name, value, true);
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.withparam) {
            buffer.append("param.").append(this.paramName).append("=\"").append(this.paramValue).append('\"');
        } else {
            buffer.append(this.paramName).append('=').append(this.paramValue);
        }
        return buffer.toString();
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

