/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;

public class SortNode
extends TypeNode
implements IOrdering {
    private final FieldNode field;
    private final SortOrder order;
    private final FieldType fieldType;

    public SortNode(String fieldName) {
        this(Expression.field(fieldName), SortOrder.ASC, FieldType.AUTO);
    }

    public SortNode(String fieldName, SortOrder order) {
        this(Expression.field(fieldName), order, FieldType.AUTO);
    }

    public SortNode(String fieldName, SortOrder order, FieldType fieldType) {
        this(Expression.field(fieldName), order, fieldType);
        SortNode.assertParamNotNull(fieldName, "fieldName");
    }

    public SortNode(FieldNode field, SortOrder order, FieldType fieldType) {
        super("sortby");
        SortNode.assertParamNotNull(field, "field");
        this.field = field;
        this.order = order;
        this.fieldType = fieldType;
    }

    @Override
    public FieldNode getField() {
        return this.field;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.order;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public TypeNode getTypeNode() {
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.accept(new SplFormatter());
    }
}

