/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Arrays;
import java.util.List;

public class SparklineAggregateNode
extends AggregateNode {
    private static final String SPARKLINE_NAME = "sparkline";
    public static final StringNode DefaultTimeSpan = new StringNode("1s");
    public static final AggregateFunction DefaultSparklineAggFunction = AggregateFunction.COUNT;
    private final StringNode timeSpan;
    private final AggregateFunction sparklineAggregateFunction;
    private final boolean asFieldDefaulted;

    public SparklineAggregateNode(AggregateFunction sparklineAggregateFunction, FieldNode field, StringNode timeSpan, FieldNode asField) {
        super(AggregateFunction.SPARKLINE, field, asField != null ? asField : SparklineAggregateNode.createDefaultAsField(sparklineAggregateFunction, field, (timeSpan == null ? DefaultTimeSpan : timeSpan).getValue()), null, null);
        this.sparklineAggregateFunction = sparklineAggregateFunction;
        this.timeSpan = timeSpan == null ? DefaultTimeSpan : timeSpan;
        this.asFieldDefaulted = this.asField.getFieldName().equals(SPARKLINE_NAME) || this.asField.equals(SparklineAggregateNode.createDefaultAsField(sparklineAggregateFunction, field, timeSpan.getValue()));
        SparklineAggregateNode.assertFunctionIsValid(this.function);
        if (sparklineAggregateFunction != null) {
            SparklineAggregateNode.assertSparklineAggregateFunctionIsSupported(sparklineAggregateFunction);
        }
    }

    public SparklineAggregateNode(AggregateFunction sparklineAggregateFunction, FieldNode field, StringNode timeSpan) {
        this(sparklineAggregateFunction, field, timeSpan, null);
    }

    public SparklineAggregateNode(AggregateFunction sparklineAggregateFunction, FieldNode field, String timeInterval, String asName) {
        this(sparklineAggregateFunction, field, new StringNode(timeInterval), new FieldNode(asName));
    }

    public SparklineAggregateNode(AggregateFunction sparklineAggregateFunction, FieldNode field, String asName) {
        this(sparklineAggregateFunction, field, DefaultTimeSpan, new FieldNode(asName));
    }

    public SparklineAggregateNode(AggregateFunction sparklineAggregateFunction) {
        this(sparklineAggregateFunction, (FieldNode)null, DefaultTimeSpan, (FieldNode)null);
    }

    public static FieldNode createDefaultAsField(AggregateFunction sparklineAggregateFunction, FieldNode field, String timeInterval) {
        String fieldName = "";
        if (field != null) {
            fieldName = field.toString();
        }
        if (sparklineAggregateFunction == null && fieldName.isEmpty()) {
            return new FieldNode(SPARKLINE_NAME);
        }
        AggregateFunction aggregateFunc = AggregateFunction.COUNT;
        if (sparklineAggregateFunction != null) {
            aggregateFunc = sparklineAggregateFunction;
        }
        String asFieldName = timeInterval.equals(DefaultTimeSpan.getValue()) ? (fieldName.isEmpty() ? String.format("%1$s(%2$s)", SPARKLINE_NAME, aggregateFunc.toString()) : String.format("%1$s(%2$s(%3$s))", SPARKLINE_NAME, aggregateFunc.toString(), fieldName)) : String.format("%1$s(%2$s(%3$s), %4$s)", SPARKLINE_NAME, aggregateFunc.toString(), fieldName, timeInterval);
        return new FieldNode(asFieldName);
    }

    public static String createDefaultName(AggregateFunction sparklineAggregateFunction, FieldNode field, String timeInterval) {
        return SparklineAggregateNode.createDefaultAsField(sparklineAggregateFunction, field, timeInterval).getFieldName();
    }

    @Override
    public FieldNode getDefaultAsField() {
        return SparklineAggregateNode.createDefaultAsField(this.sparklineAggregateFunction, this.field, (this.timeSpan == null ? DefaultTimeSpan : this.timeSpan).getValue());
    }

    @Override
    public String getDefaultName() {
        FieldNode defaultField = this.asFieldDefaulted ? this.asField : this.getDefaultAsField();
        return defaultField.getFieldName();
    }

    private static void assertFunctionIsValid(AggregateFunction function) {
        assert (function.equals((Object)AggregateFunction.SPARKLINE));
    }

    private static void assertSparklineAggregateFunctionIsSupported(AggregateFunction function) {
        List<AggregateFunction> supportedAggregateFunctions = Arrays.asList(AggregateFunction.AVG, AggregateFunction.COUNT, AggregateFunction.SUM, AggregateFunction.STDEVP, AggregateFunction.STDEV, AggregateFunction.DC, AggregateFunction.ESTDC);
        assert (supportedAggregateFunctions.contains((Object)function));
    }

    public StringNode getTimeSpan() {
        return this.timeSpan;
    }

    public AggregateFunction getSparklineAggregateFunction() {
        return this.sparklineAggregateFunction;
    }

    @Override
    public boolean hasDefaultAsName() {
        return this.asFieldDefaulted;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

