/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.search;

import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.search.SearchLeafNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.visitors.NodeVisitor;

public abstract class SearchQuotableNode
extends SearchLeafNode {
    private final String value;
    private final boolean isQuoted;
    private final TermMatcher matcher;

    SearchQuotableNode(String type, String value, boolean isNegated, boolean isQuoted, SearchModifier modifier) throws IllegalArgumentException {
        super(type, isNegated, modifier);
        if (value == null) {
            throw new IllegalArgumentException("value must not be null.");
        }
        this.value = value;
        this.isQuoted = isQuoted;
        this.matcher = new TermMatcher(SearchQuotableNode.wrapInWildcards(value), modifier == SearchModifier.CASE);
    }

    public String getValue() {
        return this.value;
    }

    public boolean is_quoted() {
        return this.isQuoted;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IMatcher getMatcher() {
        return this.matcher;
    }

    private static String wrapInWildcards(String value) {
        if (!value.startsWith("*")) {
            value = '*' + value;
        }
        if (!value.endsWith("*")) {
            value = value + "*";
        }
        return value;
    }
}

