/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

public class CapabilitySet {
    private static final char YES = '1';
    private static final char NO = '0';
    public static final char SEP = '-';
    private final boolean[] capabilities;

    CapabilitySet(boolean[] caps) throws IllegalArgumentException {
        if (caps == null) {
            throw new IllegalArgumentException("Invalid CapabilitySet");
        }
        this.capabilities = caps;
    }

    CapabilitySet(String caps) throws IllegalArgumentException {
        if (caps == null) {
            throw new IllegalArgumentException("Invalid CapabilitySet");
        }
        char[] chars = caps.toCharArray();
        this.capabilities = new boolean[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            this.capabilities[i] = chars[i] == '1';
        }
    }

    public boolean isSubsetOf(CapabilitySet set) {
        if (this.capabilities.length > set.capabilities.length) {
            return false;
        }
        for (int i = 0; i < 15; ++i) {
            if (!this.capabilities[i] || set.capabilities[i]) continue;
            return false;
        }
        return true;
    }

    boolean hasCapability(int capabilityId) {
        if (capabilityId < 0 || capabilityId > this.capabilities.length) {
            return false;
        }
        return this.capabilities[capabilityId];
    }

    public String toString() {
        char[] pieces = new char[this.capabilities.length];
        for (int i = 0; i < this.capabilities.length; ++i) {
            pieces[i] = this.getToStringChar(i);
        }
        return new String(pieces);
    }

    char getToStringChar(int index) {
        return this.capabilities[index] ? (char)'1' : '0';
    }
}

