/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.datasets.DatasetConstants;
import org.json.JSONObject;

public class Dataset
implements Comparable {
    private final String kind;
    private final String name;
    private final String module;

    public Dataset(String name) {
        String[] parts;
        String kKind = null;
        String mModule = null;
        String nName = name;
        if (nName.indexOf(":") != -1) {
            parts = name.split(":", 2);
            kKind = parts[0];
            nName = parts[1];
        }
        String string = this.kind = kKind == null ? "unknown" : kKind;
        if (!(this.kind.equals("datamodel") || this.kind.equals("job") || this.kind.equals("federated") || nName.indexOf(".") == -1)) {
            parts = nName.split("\\.");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Qualified Dataset name should not have more than one '.'");
            }
            mModule = parts[0];
            nName = parts[1];
        }
        this.module = mModule == null ? "" : mModule;
        this.name = nName;
    }

    public Dataset(String kind, String name) {
        this(kind == null || kind.equals("unknown") ? name : kind + ":" + name);
    }

    public Dataset(String module, String kind, String name) {
        this.kind = kind == null ? "unknown" : kind;
        this.name = name;
        String string = this.module = module == null ? "" : module;
        if (this.kind.equals("datamodel") && !this.module.equals("")) {
            throw new IllegalArgumentException("Module qualification is not supported for Kind Datamodel yet");
        }
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getModule() {
        return this.module;
    }

    public String getQualifiedName() {
        return this.kind.equals("unknown") ? this.name : this.kind + ":" + this.name;
    }

    public String getModuleQualifiedName() {
        return this.module.equals("") ? this.name : this.module + this.getModuleSeparator() + this.name;
    }

    public String getFullyQualifiedName() {
        StringBuilder builder = new StringBuilder();
        if (!this.kind.equals("unknown")) {
            builder.append(this.kind).append(':');
        }
        if (!this.module.equals("")) {
            builder.append(this.module).append(this.getModuleSeparator());
        }
        builder.append(this.name);
        return builder.toString();
    }

    public FromCommand from() {
        return new FromCommand(this);
    }

    public boolean equals(Object object) {
        boolean sameSame = false;
        if (object != null && object instanceof Dataset) {
            sameSame = this.kind.equals(((Dataset)object).kind) && this.name.equals(((Dataset)object).name) && this.module.equals(((Dataset)object).module);
        }
        return sameSame;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("datasettype", (Object)(this.kind.equals("unknown") ? null : this.kind));
        jsonObject.put("dataset", (Object)this.getModuleQualifiedName());
        return jsonObject;
    }

    public boolean isSupportedByV1() {
        return DatasetConstants.SUPPORTED_BY_V1.contains(this.kind);
    }

    public boolean isSupportedBySSC() {
        return DatasetConstants.SUPPORTED_BY_SSC.contains(this.kind);
    }

    private final String getModuleSeparator() {
        switch (this.kind) {
            case "index": 
            case "metric": {
                return "_____";
            }
        }
        return ".";
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean isLocalName() {
        return this.module.equals("");
    }
}

