/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DatasetsPredicateEvaluator
extends NodeVisitor<Set<IDatasetInfo>> {
    @Override
    public Set<IDatasetInfo> visit(Node node) {
        return Collections.emptySet();
    }

    @Override
    public Set<IDatasetInfo> visit(AndNode node) {
        Set<IDatasetInfo> intersection = node.getArguments().get(0).accept(this);
        for (int i = 1; i < node.getArguments().size(); ++i) {
            intersection.retainAll((Collection)node.getArguments().get(i).accept(this));
        }
        return intersection;
    }

    @Override
    public Set<IDatasetInfo> visit(OrNode node) {
        Set<IDatasetInfo> union = node.getArguments().get(0).accept(this);
        for (int i = 1; i < node.getArguments().size(); ++i) {
            union.addAll((Collection<IDatasetInfo>)node.getArguments().get(i).accept(this));
        }
        return union;
    }

    @Override
    public Set<IDatasetInfo> visit(NotNode node) {
        Set<IDatasetInfo> notSet = node.getArguments().get(0).accept(this);
        Set<IDatasetInfo> allSet = this.getDatasetsByName("*");
        allSet.removeAll(notSet);
        return allSet;
    }

    @Override
    public Set<IDatasetInfo> visit(ComparisonNode node) {
        Set<IDatasetInfo> referenced = new HashSet<IDatasetInfo>();
        switch (node.getOperator()) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                break;
            }
            default: {
                return referenced;
            }
        }
        if (!(node.getRhs() instanceof StringNode)) {
            return referenced;
        }
        String rhsVal = ((StringNode)node.getRhs()).getValue();
        if (node.getLhs() instanceof FieldNode) {
            switch (((FieldNode)node.getLhs()).getFieldName()) {
                case "kind": {
                    referenced = this.getDatasetsByKind(rhsVal);
                    break;
                }
                case "name": {
                    referenced = this.getDatasetsByName(rhsVal);
                    break;
                }
                case "module": {
                    referenced = this.getDatasetsByModule(rhsVal);
                    break;
                }
            }
        }
        return referenced;
    }

    protected Set<IDatasetInfo> getDatasetsByName(String name) {
        throw new RuntimeException("Implementor doesn't support fetching Datasets by name");
    }

    protected Set<IDatasetInfo> getDatasetsByKind(String kind) {
        throw new RuntimeException("Implementor doesn't support fetching Datasets by kind");
    }

    protected Set<IDatasetInfo> getDatasetsByModule(String module) {
        throw new RuntimeException("Implementor doesn't support fetching Datasets by module");
    }
}

