/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.splunk.commons.datasets.Property;
import com.splunk.commons.datasets.PropertyValue;
import com.splunk.commons.util.SafeArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.json.JSONObject;

@JsonIgnoreProperties(value={"reservedNames"})
public class Properties
extends HashMap<String, PropertyValue>
implements Iterable<Property> {
    private final Set<String> reservedNames = new HashSet<String>();

    public Properties() {
    }

    public Properties(Properties other) {
        if (other != null) {
            this.reservedNames.addAll(other.reservedNames);
            this.putAll(other);
        }
    }

    public Properties(String[] reservedNames, Properties other) {
        this.reservedNames.addAll(Arrays.asList(reservedNames));
        if (other != null) {
            this.reservedNames.addAll(other.reservedNames);
            this.putAll(other);
        }
    }

    public Properties(String[] reservedNames, Map<String, Object> props) throws IllegalStateException {
        List<String> reserved = Arrays.asList(reservedNames);
        if (props == null) {
            return;
        }
        ArrayList retval = new ArrayList();
        for (String key : props.keySet()) {
            if (reserved.contains(key)) continue;
            Object value = props.get(key);
            if (value == null) {
                this.put(key, null);
                continue;
            }
            this.put(key, PropertyValue.fromObject(value));
        }
    }

    public Properties(Iterable<Property> properties) {
        this.addAll(properties);
    }

    public Properties(String[] reservedNames, Iterable<Property> properties) {
        this.reservedNames.addAll(Arrays.asList(reservedNames));
        this.addAll(properties);
    }

    public void addAll(Iterable<Property> properties) {
        if (properties == null) {
            return;
        }
        for (Property property : properties) {
            this.add(property);
        }
    }

    public void add(Property property) {
        SafeArgs.valueIsNotNull(property, "The property must not be null.");
        this.validateKey(property.getName());
        this.put(property.getName(), (PropertyValue)property.getValue().orElse(null));
    }

    public Property getProperty(String name) {
        PropertyValue val = (PropertyValue)this.get(name);
        return new Property(name, val);
    }

    @Override
    public Iterator<Property> iterator() {
        return new Iterator<Property>(){
            private final Iterator<Map.Entry<String, PropertyValue>> iterator;
            {
                this.iterator = Properties.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Property next() {
                Map.Entry<String, PropertyValue> entry = this.iterator.next();
                return new Property(entry.getKey(), entry.getValue());
            }
        };
    }

    @JsonIgnore
    public JSONObject getJsonObject() {
        if (this.size() == 0) {
            return null;
        }
        JSONObject json = new JSONObject();
        this.addToJsonObject(json);
        return json;
    }

    private void addToJsonObject(JSONObject object) {
        for (Property property : this) {
            property.addToJsonObject(object);
        }
    }

    @Override
    public PropertyValue put(String key, PropertyValue value) {
        this.validateKey(key);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends PropertyValue> m) {
        for (Map.Entry<? extends String, ? extends PropertyValue> entry : m.entrySet()) {
            this.validateKey(entry.getKey());
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public PropertyValue putIfAbsent(String key, PropertyValue value) {
        this.validateKey(key);
        return this.putIfAbsent(key, value);
    }

    @Override
    public PropertyValue merge(String key, PropertyValue value, BiFunction<? super PropertyValue, ? super PropertyValue, ? extends PropertyValue> remappingFunction) {
        this.validateKey(key);
        return super.merge(key, value, remappingFunction);
    }

    private void validateKey(String key) throws IllegalStateException {
        if (this.reservedNames.contains(key)) {
            throw new IllegalStateException(String.format("Property %1$s is reserved.", key));
        }
    }

    public static Properties fromJsonObject(JSONObject object) {
        Properties props = new Properties();
        for (String key : object.keySet()) {
            Object value = object.get(key);
            try {
                props.add(new Property(key, PropertyValue.fromObject(value)));
            }
            catch (IllegalStateException ex) {
                props.add(new Property(key, PropertyValue.fromObject(value.toString())));
            }
        }
        return props;
    }
}

