/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.datasets.DataType;
import com.splunk.commons.datasets.Properties;
import com.splunk.commons.datasets.PropertyValue;
import java.util.Optional;
import org.json.JSONObject;

public class Property {
    private static final PropertyValue EMPTY_PROPERTY_VAL = new PropertyValue("");
    private final String name;
    private final PropertyValue value;

    public Property(String name, PropertyValue value) {
        this.name = name;
        this.value = value;
    }

    public Property(String name, String value) {
        this.name = name;
        this.value = new PropertyValue(value);
    }

    public Property(String name, Boolean value) {
        this.name = name;
        this.value = new PropertyValue(value);
    }

    public Property(String name, Long value) {
        this.name = name;
        this.value = new PropertyValue(value);
    }

    public String getName() {
        return this.name;
    }

    public Optional<PropertyValue> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<DataType> getType() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value.getType());
    }

    public Optional<String> getString() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value.getString());
    }

    public Optional<Long> getNumber() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value.getNumber());
    }

    public Optional<Boolean> getBoolean() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value.getBoolean());
    }

    public Optional<Properties> getProperties() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value.getProperties());
    }

    public void addToJsonObject(JSONObject json) {
        if (this.value == null) {
            throw new IllegalStateException("Attempting to serialize null property=" + this.name + '\"');
        }
        switch (this.getType().orElse(DataType.UNKNOWN)) {
            case NUMBER: {
                json.put(this.name, (Object)this.getNumber().get());
                break;
            }
            case STRING: {
                json.put(this.name, (Object)this.getString().get());
                break;
            }
            case BOOLEAN: {
                json.put(this.name, (Object)this.getBoolean().get());
                break;
            }
            case PROPERTIES: {
                json.put(this.name, (Object)this.getProperties().get().getJsonObject());
                break;
            }
            default: {
                throw new IllegalStateException("Attempting to serialize unsupported property '" + this.name + '\'');
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Property[name=\"").append(this.name).append("\" value=\"").append(this.getValue().orElse(EMPTY_PROPERTY_VAL)).append("\"]");
        return builder.toString();
    }
}

