/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.splunk.commons.datasets.DataType;
import com.splunk.commons.datasets.Properties;
import java.util.Map;

public class PropertyValue {
    @JsonValue
    private final Object value;
    private final DataType type;

    public PropertyValue(String value) {
        this.value = value;
        this.type = DataType.STRING;
    }

    public PropertyValue(Long value) {
        this.value = value;
        this.type = DataType.NUMBER;
    }

    public PropertyValue(Boolean value) {
        this.value = value;
        this.type = DataType.BOOLEAN;
    }

    public PropertyValue(Map value) {
        this.value = new Properties(new String[0], value);
        this.type = DataType.PROPERTIES;
    }

    @JsonCreator
    public PropertyValue(Object value) {
        if (value instanceof Number) {
            this.value = ((Number)value).longValue();
            this.type = DataType.NUMBER;
        } else if (value instanceof Boolean) {
            this.value = value;
            this.type = DataType.BOOLEAN;
        } else if (value instanceof String) {
            this.value = value;
            this.type = DataType.STRING;
        } else if (value instanceof Map) {
            this.value = new Properties(new String[0], (Map)value);
            this.type = DataType.PROPERTIES;
        } else {
            throw new IllegalStateException("Trying to deserialize an unsupported property type: " + value.toString());
        }
    }

    public DataType getType() {
        return this.type;
    }

    public String getString() {
        if (this.type == DataType.STRING) {
            return (String)this.value;
        }
        throw new IllegalStateException("Can't convert to String.");
    }

    public Long getNumber() {
        if (this.type == DataType.NUMBER) {
            return (Long)this.value;
        }
        throw new IllegalStateException("Can't convert to Number.");
    }

    public Boolean getBoolean() {
        if (this.type == DataType.BOOLEAN) {
            return (Boolean)this.value;
        }
        throw new IllegalStateException("Can't convert to Boolean.");
    }

    public Properties getProperties() {
        if (this.type == DataType.PROPERTIES) {
            return (Properties)this.value;
        }
        throw new IllegalStateException("Can't convert to Properties.");
    }

    public String toString() {
        switch (this.type) {
            case STRING: {
                return this.getString();
            }
            case NUMBER: {
                return this.getNumber().toString();
            }
            case BOOLEAN: {
                return this.getBoolean().toString();
            }
            case PROPERTIES: {
                return this.getProperties().toString();
            }
        }
        throw new IllegalStateException("Can't convert property value contents to string for type=" + (Object)((Object)this.type));
    }

    public static PropertyValue fromObject(Object value) {
        return new PropertyValue(value);
    }
}

