/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.GroupByCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.datasets.PlanProviderFactory;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.providers.IFromProvider;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.handlers.IGroupByHandler;
import com.splunk.commons.providers.handlers.IOrderByHandler;
import com.splunk.commons.providers.handlers.ISelectHandler;
import com.splunk.commons.providers.handlers.IWhereHandler;
import java.io.IOException;

public class CompensatingFromProvider
implements IFromProvider {
    private final IDatasetResolver datasetResolver;
    private IPlanProvider handler;
    private CommandNode command;
    private boolean whereEnabled;
    private boolean groupByEnabled;
    private boolean orderByEnabled;
    private boolean selectEnabled;

    public CompensatingFromProvider(IDatasetResolver datasetResolver) {
        this.datasetResolver = datasetResolver;
    }

    private void initCommon() {
        this.whereEnabled = true;
        this.groupByEnabled = true;
        this.selectEnabled = true;
        this.orderByEnabled = true;
    }

    @Override
    public void initialize(Dataset dataset) throws IOException {
        if (!(dataset instanceof TransientDataset)) {
            IDatasetInfo datasetInfo = Modules.resolveRecursive(this.datasetResolver, dataset);
            if (datasetInfo == null) {
                throw new IllegalArgumentException("Dataset " + dataset + " couldn't be resolved from catalog.");
            }
            dataset = new Dataset(datasetInfo.getModule(), datasetInfo.getKind(), datasetInfo.getName());
        }
        this.handler = PlanProviderFactory.getPlanProvider(dataset, this.datasetResolver);
        this.handler.initialize(dataset);
        this.initCommon();
    }

    @Override
    public void initialize(Dataset[] datasets) throws IOException {
        this.handler = PlanProviderFactory.getPlanProvider(datasets[0], this.datasetResolver);
        this.handler.initialize(datasets);
        this.initCommon();
    }

    public void initialize(Dataset dataset, IPlanProvider provider) throws IOException {
        this.handler = provider;
        this.handler.initialize(dataset);
        this.initCommon();
    }

    @Override
    public CommandNode getCommand() {
        CommandNode source = this.getSource();
        if (source instanceof GroupByCommand) {
            throw new RuntimeException("SELECT needed if you do a GROUP BY");
        }
        return source;
    }

    @Override
    public void where(IWherePredicate predicate) {
        if (!this.whereEnabled) {
            throw new RuntimeException("Can't call WHERE twice or after GROUPBY or SELECT");
        }
        this.whereEnabled = false;
        if (predicate == null) {
            return;
        }
        if (this.handler instanceof IWhereHandler) {
            ((IWhereHandler)this.handler).where(predicate);
        } else {
            this.command = CompensatingFromProvider.appendWhere(this.getSource(), predicate);
        }
    }

    @Override
    public void groupBy(IGroupBy[] fields) {
        if (!this.groupByEnabled) {
            throw new RuntimeException("Can't call GROUP BY twice or after SELECT");
        }
        this.whereEnabled = false;
        this.groupByEnabled = false;
        if (fields == null || fields.length == 0) {
            return;
        }
        if (!this.isCompensating() && this.handler instanceof IGroupByHandler) {
            ((IGroupByHandler)this.handler).groupBy(fields);
        } else {
            this.command = CompensatingFromProvider.appendGroupBy(this.getSource(), fields);
        }
    }

    @Override
    public void select(ISelection[] projections) {
        if (!this.selectEnabled) {
            throw new RuntimeException("Can't call SELECT twice");
        }
        this.whereEnabled = false;
        this.groupByEnabled = false;
        this.selectEnabled = false;
        if (projections == null || projections.length == 0) {
            return;
        }
        if (!this.isCompensating() && this.handler instanceof ISelectHandler) {
            ((ISelectHandler)this.handler).select(projections);
        } else {
            this.command = CompensatingFromProvider.appendSelect(this.getSource(), projections);
        }
    }

    @Override
    public void orderBy(IOrdering[] orderings) {
        if (!this.orderByEnabled) {
            throw new RuntimeException("Can't call SELECT twice");
        }
        this.whereEnabled = false;
        this.groupByEnabled = false;
        this.selectEnabled = false;
        this.orderByEnabled = false;
        if (orderings == null || orderings.length == 0) {
            return;
        }
        if (!this.isCompensating() && this.handler instanceof IOrderByHandler) {
            ((IOrderByHandler)this.handler).orderBy(orderings);
        } else {
            this.command = CompensatingFromProvider.appendOrderBy(this.getSource(), orderings);
        }
    }

    private boolean isCompensating() {
        return this.command != null;
    }

    private CommandNode getSource() {
        if (this.command == null) {
            return this.handler.getCommand();
        }
        return this.command;
    }

    private static CommandNode appendWhere(CommandNode source, IWherePredicate predicate) {
        return new WhereCommand(source, predicate);
    }

    private static CommandNode appendGroupBy(CommandNode source, IGroupBy[] fields) {
        return new GroupByCommand(source, fields);
    }

    private static CommandNode appendSelect(CommandNode source, ISelection[] selections) {
        if (source instanceof GroupByCommand) {
            return ((GroupByCommand)source).select(selections);
        }
        try {
            return new FieldsCommand(source, CompensatingFromProvider.asFieldNodes(selections));
        }
        catch (RuntimeException ex) {
            return new GroupByCommand(source, (IGroupBy[])null).select(selections);
        }
    }

    private static CommandNode appendOrderBy(CommandNode source, IOrdering[] orderings) {
        if (source instanceof GroupByCommand) {
            throw new RuntimeException("Following a GROUP BY you must SELECT before you ORDER BY.");
        }
        return new SortCommand(source, orderings, 0);
    }

    private static FieldNode[] asFieldNodes(ISelection[] selections) {
        FieldNode[] fields = new FieldNode[selections.length];
        for (int i = 0; i < fields.length; ++i) {
            if (!(selections[i] instanceof FieldNode)) {
                throw new RuntimeException("Invalid field node specified: " + selections[i]);
            }
            fields[i] = (FieldNode)selections[i];
        }
        return fields;
    }
}

