/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.nodes.Command;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.Search;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.providers.IPlanProvider;
import java.io.IOException;
import java.util.ArrayList;

public class IndexPlanProvider
implements IPlanProvider {
    private ISearchPredicate predicate;

    private static void validate(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("index")) {
            throw new IOException("IndexPlanProvider only supports index datasets.");
        }
    }

    @Override
    public void initialize(Dataset dataset) throws IOException {
        IndexPlanProvider.validate(dataset);
        this.predicate = Search.equal("index", dataset.getModuleQualifiedName());
    }

    @Override
    public void initialize(Dataset[] datasets) throws IOException {
        ArrayList<ISearchPredicate> indexes = new ArrayList<ISearchPredicate>(datasets.length);
        for (int i = 0; i < datasets.length; ++i) {
            IndexPlanProvider.validate(datasets[i]);
            indexes.add(i, Search.equal("index", datasets[i].getModuleQualifiedName()));
        }
        this.predicate = Search.or(indexes);
    }

    @Override
    public CommandNode getCommand() {
        return Command.search(this.predicate);
    }
}

