/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.datasets.PartitionedDataset;
import com.splunk.commons.datasets.Partitions;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.handlers.IWhereHandler;
import com.splunk.commons.visitors.PredicatePushdownVisitor;
import java.io.IOException;
import org.bson.types.ObjectId;

public class PartitionedDatasetPlanProvider
implements IPlanProvider,
IWhereHandler {
    private Dataset dataset;
    private IWherePredicate where;
    private final IDatasetResolver datasetResolver;
    private PartitionedDataset resolvedDataset;

    public PartitionedDatasetPlanProvider(IDatasetResolver datasetResolver) {
        this.datasetResolver = datasetResolver;
    }

    @Override
    public void initialize(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("partitioned")) {
            throw new IOException("PartitionedDatasetProvider can only handle Partitioned datasets.");
        }
        this.dataset = dataset;
        this.resolvedDataset = (PartitionedDataset)this.datasetResolver.resolveDataset(dataset);
        if (this.resolvedDataset == null) {
            throw new IllegalArgumentException(String.format("Dataset with name %s could not be resolved!", dataset.getName()));
        }
    }

    @Override
    public CommandNode getCommand() {
        if (this.where == null) {
            return this.resolvedDataset.expand();
        }
        Partitions transientP = this.resolvedDataset.getPartitions().filter(this.where);
        PartitionedDataset transientDS = transientP.toArray().length != this.resolvedDataset.getPartitions().toArray().length ? new PartitionedDataset(new ObjectId(), this.resolvedDataset.getModule(), this.resolvedDataset.getName(), this.resolvedDataset.getOwner(), this.resolvedDataset.getProperties(), transientP) : this.resolvedDataset;
        return transientDS.expand().searchAgain(this.where).accept(new PredicatePushdownVisitor());
    }

    @Override
    public void where(IWherePredicate where) {
        this.where = where;
    }
}

