/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.security;

import com.splunk.commons.security.BasicCredentials;

public class SplunkConnection {
    private final BasicCredentials credentials;
    private final String host;
    private final int port;

    public SplunkConnection() {
        this(new BasicCredentials(), "localhost", 8089);
    }

    public SplunkConnection(BasicCredentials credentials, String host, int port) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials must be provided.");
        }
        if (host == null || host.equals("")) {
            throw new IllegalArgumentException("Host must be provided.");
        }
        if (port < 1) {
            throw new IllegalArgumentException("Port must be a greater than 0.");
        }
        this.credentials = credentials;
        this.host = host;
        this.port = port;
    }

    public BasicCredentials getCredentials() {
        return this.credentials;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String serialize() {
        return String.format("host=%1$s port=%2$s %3$s", this.host, this.port, this.credentials.serialize());
    }
}

