/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.util;

import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.nodes.CommandNode;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VisitorUtil {
    private static final Logger logger = LoggerFactory.getLogger(VisitorUtil.class);

    private VisitorUtil() {
    }

    public static CommandNode rebuild(CommandNode node) {
        logger.debug("CommandRebuilder visit is called: command={}, number of sources={}" + node.getCommandName(), (Object)node.getSources().length);
        CommandNode[] visitedSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < visitedSources.length; ++i) {
            visitedSources[i] = VisitorUtil.rebuild(node.getSources()[i]);
        }
        if (visitedSources.length == 0) {
            logger.debug("CommandRebuilder visits 0 source: command={}", (Object)node.getCommandName());
            return node;
        }
        if (visitedSources.length == 1) {
            logger.debug("CommandRebuilder visits 1 source: command={}, source={}", (Object)node.getCommandName(), (Object)visitedSources[0].getCommandName());
            return node.setSource(visitedSources[0]);
        }
        return node.setSources(visitedSources);
    }

    private static <T> void ensureAtMostOnce(String optionName, ParseTree ctx, T node) throws SPLParseException {
        if (ctx != null && node != null) {
            throw new SPLParseException("Option " + optionName + " can only be used at most once.");
        }
    }

    private static void ensureAtMostOnce(String optionName, List<?> list) throws SPLParseException {
        if (list != null && list.size() > 1) {
            throw new SPLParseException("Option " + optionName + " can only be used at most once.");
        }
    }

    private static void ensureExactlyOnce(String optionName, List<?> list) throws SPLParseException {
        if (list == null || list.size() != 1) {
            throw new SPLParseException("Option " + optionName + " can only be used once.");
        }
    }

    public static <T> T visitAtMostOnce(String optionName, ParseTree ctx, T node, ParseTreeVisitor visitor) throws SPLParseException {
        if (ctx == null) {
            return node;
        }
        VisitorUtil.ensureAtMostOnce(optionName, ctx, node);
        return (T)visitor.visit(ctx);
    }

    public static <T> T visitAtMostOnce(String optionName, List<? extends ParseTree> list, ParseTreeVisitor visitor) throws SPLParseException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        VisitorUtil.ensureAtMostOnce(optionName, list);
        return (T)visitor.visit(list.get(0));
    }

    public static <T> T visitExactlyOnce(String optionName, List<? extends ParseTree> list, ParseTreeVisitor visitor) throws SPLParseException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        VisitorUtil.ensureExactlyOnce(optionName, list);
        return (T)visitor.visit(list.get(0));
    }

    public static boolean allNull(Object ... objects) {
        for (Object o : objects) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static enum JobStatus {
        GENERATING_STATE,
        DFS_STATE,
        SPLUNK_SH_STATE,
        FSH_STATE,
        UNDEFINED_STATE;

    }
}

