/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandSourceKind;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;

public class CommandExecutor
extends NodeVisitor<Boolean> {
    private String mode = "DFS:    ";
    private final StringBuilder builder = new StringBuilder();
    private final SplFormatter formatter = new SplFormatter();

    @Override
    public Boolean visit(Node node) {
        return false;
    }

    @Override
    public Boolean visit(StatsCommand node) {
        String spl = node.accept(this.formatter);
        if (node.getSource().getCommandName() == "rdin") {
            node.getSource().accept(this);
            this.builder.append(this.mode).append(spl.substring(spl.lastIndexOf("| stats")));
            return true;
        }
        String prestatsArgs = spl.substring(spl.lastIndexOf("| stats")).replace("| stats", "");
        UnknownCommand prestats = new UnknownCommand(node.getSource(), "prestats", prestatsArgs, CommandType.SP_STREAMREPORT, node.getFieldPropertiesArray());
        String remoteSpl = prestats.accept(this.formatter);
        UnknownCommand rdin = new UnknownCommand("rdin", " [" + remoteSpl + ']', CommandType.SP_STREAM, node.getFieldPropertiesArray());
        return node.setSource(rdin).accept(this);
    }

    @Override
    public Boolean visit(UnknownCommand node) {
        if (node.getCommandName() == "rdout") {
            this.mode = "REMOTE: ";
        }
        if (node.getCommandSourceKind() == CommandSourceKind.SINGLE && !node.getSource().accept(this).booleanValue()) {
            return false;
        }
        this.builder.append(this.mode).append("| ").append(node.getCommandName()).append(node.getArguments()).append('\n');
        if (node.getCommandName() == "rdout") {
            this.mode = "DFS:    ";
        }
        return true;
    }

    @Override
    public Boolean visit(EvalCommand node) {
        if (node.getSource().accept(this).booleanValue()) {
            this.builder.append(this.mode).append("| eval ").append('\n');
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(SearchCommand node) {
        if (node.getCommandSourceKind() == CommandSourceKind.SINGLE && !node.getSource().accept(this).booleanValue()) {
            return false;
        }
        this.builder.append(this.mode).append("| search ").append(node.getPredicate().getNode().accept(this.formatter)).append('\n');
        return true;
    }

    public String results() {
        return this.builder.toString();
    }
}

