/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.ArrayList;

public class ComparisonNodeModifierVisitor
extends NodeVisitor<Node> {
    protected FieldNode getLhs() {
        throw new RuntimeException("Implementer didn't specify an LHS field node to compare against");
    }

    Node modify(Node node) {
        return node;
    }

    @Override
    public Node visit(Node node) {
        return node;
    }

    @Override
    public Node visit(SearchOrNode node) {
        ArrayList<ISearchPredicate> argsList = new ArrayList<ISearchPredicate>();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            ISearchPredicate predicate = (ISearchPredicate)((Object)node.getArguments().get(i).accept(this));
            if (predicate == null) continue;
            argsList.add(predicate);
        }
        if (argsList.size() == 1) {
            ISearchPredicate[] visitedArgs = new ISearchPredicate[argsList.size()];
            return new SearchAndNode(argsList.toArray(visitedArgs));
        }
        if (argsList.size() > 1) {
            ISearchPredicate[] visitedArgs = new ISearchPredicate[argsList.size()];
            return new SearchOrNode(argsList.toArray(visitedArgs));
        }
        return null;
    }

    @Override
    public Node visit(SearchAndNode node) {
        ArrayList<ISearchPredicate> argsList = new ArrayList<ISearchPredicate>();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            ISearchPredicate predicate = (ISearchPredicate)((Object)node.getArguments().get(i).accept(this));
            if (predicate == null) continue;
            argsList.add(predicate);
        }
        if (!argsList.isEmpty()) {
            ISearchPredicate[] visitedArgs = new ISearchPredicate[argsList.size()];
            return new SearchAndNode(argsList.toArray(visitedArgs));
        }
        return new SearchAndNode(new ISearchPredicate[0]);
    }

    @Override
    public Node visit(SearchQuotableNode node) {
        return node;
    }

    @Override
    public Node visit(SearchComparisonNode node) {
        if (node.getLhs().equals(this.getLhs())) {
            switch (node.getOperator()) {
                case EQUAL: 
                case EQUAL_EQUAL: 
                case NOT_EQUAL: {
                    StringNode rhs = (StringNode)node.getRhs();
                    if (rhs == null) {
                        throw new IllegalStateException("Encountered index=<value> expression, but <value> was not a StringNode.");
                    }
                    return this.modify(node);
                }
            }
            return node;
        }
        return node;
    }

    @Override
    public Node visit(AndNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (IWherePredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new AndNode(args);
    }

    @Override
    public Node visit(OrNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (IWherePredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new OrNode(args);
    }

    @Override
    public Node visit(NotNode node) {
        return new NotNode((IPredicate)((Object)node.getArguments().get(0).accept(this)));
    }

    @Override
    public Node visit(SearchNotNode node) {
        return new SearchNotNode((IPredicate)((Object)node.getArguments().get(0).accept(this)));
    }

    @Override
    public Node visit(ComparisonNode node) {
        if (node.getLhs() instanceof FieldNode && ((FieldNode)node.getLhs()).equals(this.getLhs())) {
            switch (node.getOperator()) {
                case EQUAL: 
                case EQUAL_EQUAL: 
                case NOT_EQUAL: {
                    if (node.getRhs() instanceof StringNode) {
                        StringNode rhs = (StringNode)node.getRhs();
                        if (rhs == null) {
                            throw new IllegalStateException("Encountered index=<value> expression, but <value> was not a StringNode.");
                        }
                        return this.modify(node);
                    }
                    if (!(node.getRhs() instanceof FieldNode)) break;
                    return this.modify(new ComparisonNode(node.getOperator(), node.getLhs(), new StringNode(node.getRhs().accept(new SplFormatter()))));
                }
            }
        }
        return node;
    }
}

