/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.Search;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.MeasureNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.visitors.CommandRebuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class MStatsExpanderVisitor
extends CommandRebuilder {
    private final IDatasetResolver datasetResolver;

    public MStatsExpanderVisitor(IDatasetResolver datasetResolver) {
        this.datasetResolver = datasetResolver;
    }

    @Override
    public CommandNode visit(CommandNode node) {
        return node;
    }

    @Override
    public CommandNode visit(MStatsCommand node) {
        AggregateNode[] aggregates = new AggregateNode[node.getAggregates().length];
        HashSet<String> referencedMetrics = new HashSet<String>();
        Hashtable<String, String> asToMetricNameMap = new Hashtable<String, String>();
        for (int i = 0; i < aggregates.length; ++i) {
            AggregateNode aggregate = node.getAggregates()[i];
            Object mapping = null;
            if (mapping instanceof MeasureNode) {
                AggregateNode valueVersion;
                MeasureNode measure = mapping;
                aggregates[i] = valueVersion = new AggregateNode(aggregate.getFunction(), Expression.field(measure.getReference().getMeasureName()), aggregate.getAsName());
                referencedMetrics.add(measure.getReference().getMetricName());
                asToMetricNameMap.put(aggregate.getAsName(), measure.getReference().getMetricName());
                continue;
            }
            aggregates[i] = aggregate;
        }
        boolean compensationRequired = referencedMetrics.size() > 1;
        IGroupBy[] byFields = MStatsExpanderVisitor.createByClause(node.getByFields().toArray(new IGroupBy[0]), compensationRequired);
        ISearchPredicate predicate = MStatsExpanderVisitor.createWhereClause((ISearchPredicate)node.getPredicate(), referencedMetrics);
        CommandNode source = new TStatsCommand(aggregates, byFields, predicate);
        if (compensationRequired) {
            source = MStatsExpanderVisitor.createCompensatingEval(source, asToMetricNameMap);
            source = MStatsExpanderVisitor.createCompensatingStats(source, aggregates, byFields);
        }
        return source;
    }

    private static StatsCommand createCompensatingStats(CommandNode source, AggregateNode[] originalAggregates, IGroupBy[] originalByFields) {
        IGroupBy[] byFields = Arrays.copyOfRange(originalByFields, 1, originalByFields.length);
        AggregateNode[] aggregates = new AggregateNode[originalAggregates.length];
        for (int i = 0; i < aggregates.length; ++i) {
            AggregateNode original = originalAggregates[i];
            aggregates[i] = new AggregateNode(AggregateFunction.FIRST, original.getAsName(), original.getAsName());
        }
        return source.stats(aggregates, byFields);
    }

    private static EvalCommand createCompensatingEval(CommandNode source, Map<String, String> asToMetricNameMap) {
        AssignmentNode[] assignments = new AssignmentNode[asToMetricNameMap.size()];
        int i = 0;
        for (String key : asToMetricNameMap.keySet()) {
            AssignmentNode assignment;
            assignments[i] = assignment = new AssignmentNode(key, (TypeNode)FunctionNode.ifFunction(Expression.equal(Expression.field("metric_name"), Expression.string(asToMetricNameMap.get(key))), Expression.field(key), NullNode.INSTANCE));
            ++i;
        }
        return source.eval(assignments);
    }

    private static ISearchPredicate createWhereClause(ISearchPredicate where, Set<String> referencedMetrics) {
        if (where == null) {
            where = new SearchAndNode(new ISearchPredicate[0]);
        }
        if (referencedMetrics.isEmpty()) {
            return where;
        }
        int size = referencedMetrics.size();
        ISearchPredicate[] orClauses = new ISearchPredicate[size];
        int i = 0;
        for (String metric : referencedMetrics) {
            orClauses[i++] = Search.equal("metric_name", metric);
        }
        where = (ISearchPredicate)where.and(new SearchOrNode(orClauses));
        return where;
    }

    private static IGroupBy[] createByClause(IGroupBy[] byFields, boolean appendSource) {
        if (!appendSource) {
            return byFields;
        }
        IGroupBy[] clone = new IGroupBy[byFields.length + 1];
        clone[0] = Expression.field("metric_name");
        for (int i = 0; i < byFields.length; ++i) {
            clone[i + 1] = byFields[i];
        }
        return clone;
    }
}

