/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IExpression;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.AddInfoCommand;
import com.splunk.commons.ast.nodes.commands.AppendCommand;
import com.splunk.commons.ast.nodes.commands.ApplyCommand;
import com.splunk.commons.ast.nodes.commands.BinCommand;
import com.splunk.commons.ast.nodes.commands.Conditional;
import com.splunk.commons.ast.nodes.commands.DatamodelCommand;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.FitCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.IfCommand;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.IntoCommand;
import com.splunk.commons.ast.nodes.commands.IplocationCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.LoadJobCommand;
import com.splunk.commons.ast.nodes.commands.LookupCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.commands.MvexpandCommand;
import com.splunk.commons.ast.nodes.commands.NoOpCommand;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.RegexCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.ReverseCommand;
import com.splunk.commons.ast.nodes.commands.RexCommand;
import com.splunk.commons.ast.nodes.commands.RunSearchCommand;
import com.splunk.commons.ast.nodes.commands.SavedsearchCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SelfJoinCommand;
import com.splunk.commons.ast.nodes.commands.SendalertCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsOptions;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.commons.ast.nodes.commands.TimechartCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.EvalAggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.InNode;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.JoinType;
import com.splunk.commons.ast.nodes.expressions.LogSpanNode;
import com.splunk.commons.ast.nodes.expressions.MultiValueNode;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.PercentageAggregateNode;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TableColumnOptionsNode;
import com.splunk.commons.ast.nodes.expressions.TimeSpanNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchInNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.datasets.ConstantField;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SplFormatter
extends NodeVisitor<String> {
    private final boolean enableDatasetSerializationShorthand;
    private boolean useSpanOptionMode = true;

    public SplFormatter() {
        this(true);
    }

    public SplFormatter(boolean enableDatasetSerializationShorthand) {
        this.enableDatasetSerializationShorthand = enableDatasetSerializationShorthand;
    }

    @Override
    public String visit(Node node) {
        throw new UnsupportedOperationException("SplFormatter does not support this node: " + node.getClass());
    }

    @Override
    public String visit(CommandNode node) {
        String body = String.format("| %1$s <unexpectedly tried to format unrecognized command>", node.getCommandName());
        if (node.getSources().length == 1) {
            return String.format("%1$s %2$s", node.getSources()[0].accept(this), body);
        }
        return body;
    }

    @Override
    public String visit(AppendCommand node) {
        return String.format("%1$s | append [%2$s]", node.getLeftSource().accept(this), node.getRightSource().accept(this));
    }

    @Override
    public String visit(BinCommand node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getSources()[0].accept(this)).append(" | bin ").append(node.getBinNode().accept(this));
        if (node.getNewField() != null) {
            sb.append(" AS ").append(node.getNewField().accept(this));
        }
        return sb.toString();
    }

    @Override
    public String visit(DatamodelCommand node) {
        return String.format("| datamodel %1$s %2$s %3$s", node.getDatamodelName(), node.getObjectName(), node.getMode().toString());
    }

    @Override
    public String visit(JoinNode node) {
        if (node.getLeftSide().equals(node.getRightSide())) {
            return node.getLeftSide().accept(this);
        }
        return node.getLeftSide().accept(this) + " AS " + node.getRightSide().accept(this);
    }

    @Override
    public String visit(LoadJobCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("| loadjob ");
        buffer.append(node.getJobName());
        return buffer.toString();
    }

    @Override
    public String visit(LookupCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | lookup ");
        if (node.isLocal()) {
            buffer.append("local=true ");
        }
        if (node.isUpdate()) {
            buffer.append("update=true ");
        }
        buffer.append(node.getLookupName());
        buffer.append(' ');
        Object[] joins = new String[node.getJoinKeys().length];
        for (int i = 0; i < joins.length; ++i) {
            joins[i] = node.getJoinKeys()[i].accept(this);
        }
        buffer.append(StringUtils.commaSeparate(joins));
        if (node.getMode() != LookupCommand.LookupMode.ALL) {
            Object[] selections = new String[node.getSelections().length];
            for (int i = 0; i < selections.length; ++i) {
                selections[i] = node.getSelections()[i].accept(this);
            }
            if (node.getMode() == LookupCommand.LookupMode.OUTPUTNEW) {
                buffer.append(" OUTPUTNEW ");
            } else {
                buffer.append(" OUTPUT ");
            }
            buffer.append(StringUtils.commaSeparate(selections));
        }
        return buffer.toString();
    }

    @Override
    public String visit(UnknownCommand node) {
        String body = String.format("| %1$s%2$s%3$s", node.getCommandName(), node.getArguments().isEmpty() ? "" : " ", node.getArguments().trim());
        if (node.getSources().length == 1) {
            return String.format("%1$s %2$s", node.getSource().accept(this), body);
        }
        return body;
    }

    @Override
    public String visit(EvalCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | eval ");
        AssignmentNode[] nodes = node.getAssignments();
        Object[] assignments = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            assignments[i] = this.visit(nodes[i], true, false);
        }
        buffer.append(StringUtils.commaSeparate(assignments));
        return buffer.toString();
    }

    @Override
    public String visit(AssignmentNode node) {
        return String.format("%1$s=%2$s", node.getField().accept(this), node.getExpression().accept(this));
    }

    private String visit(AssignmentNode node, boolean lhsConvert, boolean rhsConvert) {
        String leftField = node.getField().accept(this);
        String rightValue = node.getExpression().accept(this);
        if (lhsConvert) {
            leftField = leftField.replaceAll("^'|'$", "\"");
        }
        if (rhsConvert) {
            rightValue = rightValue.replaceAll("^'|'$", "\"");
        }
        return leftField + '=' + rightValue;
    }

    @Override
    public String visit(RunSearchCommand node) {
        ConstantField[] args;
        StringBuilder buffer = new StringBuilder();
        buffer.append("| runsearch[ ");
        buffer.append(node.getSearchCommand().accept(this));
        buffer.append(" ] ");
        for (ConstantField arg : args = node.getArguments()) {
            buffer.append(arg).append(' ');
        }
        return buffer.toString();
    }

    @Override
    public String visit(SearchAndNode node) {
        return StringUtils.join(" ", this.asSplArray(node.getArguments(), true));
    }

    @Override
    public String visit(SearchNotNode node) {
        return node.getFunction() + " (" + node.getArguments().get(0).accept(this) + ')';
    }

    @Override
    public String visit(SearchInNode node) {
        return this.visit(node.getLhs(), true) + " in (" + StringUtils.commaSeparate(this.asSplArray(node.getRhs(), true)) + ')';
    }

    @Override
    public String visit(SearchOrNode node) {
        return StringUtils.join(" OR ", this.asSplArray(node.getArguments(), true));
    }

    @Override
    public String visit(SearchXorNode node) {
        return StringUtils.join(" XOR ", this.asSplArray(node.getArguments(), true));
    }

    @Override
    public String visit(SearchSubSearchPredicateNode node) {
        return '[' + node.getSubsearch().accept(this) + ']';
    }

    @Override
    public String visit(SearchComparisonNode node) {
        FieldNode leftNode = node.getLhs();
        String lhs = leftNode != null ? this.visit(leftNode, true) : node.getLhs().accept(this);
        lhs = SplFormatter.applyModifier(SplFormatter.applyQuoting(lhs, node.is_lhs_quoted()), SearchModifier.NONE);
        String rhs = node.getRhs() instanceof StringNode ? ((StringNode)node.getRhs()).getValue() : node.getRhs().accept(this);
        rhs = SplFormatter.applyModifier(SplFormatter.applyQuoting(rhs, node.is_rhs_quoted()), node.getModifier());
        String op = node.getOperator().toSplOperator();
        if (node.getOperator() == Operator.EQUAL_EQUAL) {
            op = Operator.EQUAL.toSplOperator();
        }
        String retValue = String.format("%1$s%2$s%3$s", lhs, op, rhs);
        return SplFormatter.applyNegation(retValue, node.is_negated());
    }

    @Override
    public String visit(SearchQuotableNode node) {
        String withQuote = SplFormatter.applyQuoting(node.getValue(), node.is_quoted());
        withQuote = withQuote.replaceAll("^'|'$", "\"");
        return SplFormatter.applyNegation(SplFormatter.applyModifier(withQuote, node.getModifier()), node.is_negated());
    }

    @Override
    public String visit(FieldsCommand node) {
        if (node.getFields().length == 0) {
            return String.format("%1$s | fields%2$s", node.getSources()[0].accept(this), node.isRemoveFields() ? " -" : "");
        }
        return String.format("%1$s | fields %2$s%3$s%4$s", node.getSources()[0].accept(this), node.isKeepColumnOrder() ? "keepcolorder=true " : "", node.isRemoveFields() ? "- " : "", StringUtils.commaSeparate(this.asSplArray(node.getFields(), true)));
    }

    @Override
    public String visit(FromCommand node) {
        if (!node.getDataset().getKind().equals("unknown") && node.getDataset().getKind().equals("internal")) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("| FROM ");
        buffer.append(node.getDataset());
        if (node.getWhere() != null) {
            buffer.append(" WHERE ");
            buffer.append(node.getWhere().getNode().accept(this));
        }
        if (node.getGroupBy() != null && node.getGroupBy().length > 0) {
            boolean oldUseSpanOptionMode = this.useSpanOptionMode;
            this.useSpanOptionMode = false;
            buffer.append(" GROUP BY ");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getGroupBy()), true)));
            this.useSpanOptionMode = oldUseSpanOptionMode;
        }
        if (node.getOrderings() != null && node.getOrderings().length > 0) {
            buffer.append(" ORDER BY ");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(node.getOrderings())));
        }
        if (node.getSelections() != null && node.getSelections().length > 0) {
            buffer.append(" SELECT ");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getSelections()), true)));
        }
        return buffer.toString();
    }

    @Override
    public String visit(HeadCommand node) {
        BooleanNode keeplast;
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        if (node.isMapMode()) {
            buffer.append(" | prehead");
        } else {
            buffer.append(" | head");
        }
        IWherePredicate conditions = node.getPredicate();
        if (conditions != null) {
            buffer.append(" (").append(conditions.getTypeNode().accept(this)).append(')');
        }
        if ((keeplast = node.getKeeplast()) != null) {
            buffer.append(" keeplast=").append(keeplast);
        } else if (node.isMapMode()) {
            buffer.append(" keeplast=false");
        }
        BooleanNode nullsMatch = node.getNullIsMatch();
        if (nullsMatch != null) {
            buffer.append(" null=").append(nullsMatch);
        } else if (node.isMapMode()) {
            buffer.append(" null=false");
        }
        NumberNode limit = node.getLimit();
        if (limit != null) {
            buffer.append(" limit=").append(limit.getValue());
        }
        return buffer.toString();
    }

    @Override
    public String visit(DedupCommand node) {
        IOrdering[] sortFields;
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        if (node.isPreDedupMode()) {
            sortFields = node.getSortBy();
            if (sortFields != null && sortFields.length > 0) {
                buffer.append(" | presort 0");
                for (IOrdering sortField : sortFields) {
                    buffer.append(' ').append(sortField);
                }
            }
            buffer.append(" | prededup");
        } else {
            buffer.append(" | dedup");
        }
        if (node.getLimit() != 1) {
            buffer.append(' ').append(node.getLimit());
        }
        if (node.getFields() != null) {
            buffer.append(' ').append(StringUtils.commaSeparate(this.asSplArray(node.getFields(), true)));
        }
        if (node.isConsecutive()) {
            buffer.append(" consecutive=t");
        }
        if (node.isKeepEmpty()) {
            buffer.append(" keepempty=t");
        }
        if (node.isKeepEvents()) {
            buffer.append(" keepevents=t");
        }
        if (!node.isPreDedupMode() && (sortFields = node.getSortBy()) != null && sortFields.length > 0) {
            buffer.append(" sortby");
            for (IOrdering sortField : sortFields) {
                buffer.append(' ').append(sortField);
            }
        }
        return buffer.toString();
    }

    @Override
    public String visit(IfCommand node) {
        Object[] branches = new String[node.getConditionals().length];
        for (int i = 0; i < node.getConditionals().length; ++i) {
            branches[i] = node.getConditionals()[i].accept(this);
        }
        return String.format("%1$s | %2$s", node.getSources()[0].accept(this), StringUtils.join(" el", branches));
    }

    @Override
    public String visit(InputlookupCommand node) {
        StringBuilder buffer = new StringBuilder();
        if (node.isAppend()) {
            buffer.append(node.getSource().accept(this)).append(" | inputlookup");
            buffer.append(" append=t");
        } else {
            buffer.append("| inputlookup");
        }
        if (node.getStart() != 0) {
            buffer.append(" start=").append(node.getStart());
        }
        if (node.getMax() != 0) {
            buffer.append(" max=").append(node.getMax());
        }
        buffer.append(' ').append(SplFormatter.applyQuotingIfContainsWhitespace(node.getLookupName()));
        if (node.getWhere() != null) {
            buffer.append(" WHERE ").append(((Node)((Object)node.getWhere())).accept(this));
        }
        return buffer.toString();
    }

    @Override
    public String visit(IntoCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | into");
        if (node.getMode() != null) {
            buffer.append(" mode=");
            buffer.append((Object)node.getMode());
        }
        buffer.append(' ');
        buffer.append(node.getTarget());
        return buffer.toString();
    }

    @Override
    public String visit(IplocationCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | iplocation");
        if (!node.getPrefix().isEmpty()) {
            buffer.append(" prefix=");
            buffer.append(node.getPrefix());
        }
        if (node.isAllFields()) {
            buffer.append(" allfields=t");
        }
        if (!node.getLang().equals("")) {
            buffer.append(" lang=");
            buffer.append(node.getLang());
        }
        buffer.append(' ');
        buffer.append(node.getIpField());
        return buffer.toString();
    }

    @Override
    public String visit(JoinCommand node) {
        StringBuilder buffer = new StringBuilder();
        Object[] joinClauses = new String[node.getJoinClauses().length];
        buffer.append(node.getLhs().accept(this));
        buffer.append(" | join");
        SplFormatter.visitJoinCommandOptions(buffer, node);
        if (JoinCommand.isV2(node)) {
            buffer.append(" left=").append(node.getLhsAlias());
            buffer.append(" right=").append(node.getRhsAlias());
            buffer.append(" where ");
            for (int i = 0; i < joinClauses.length; ++i) {
                JoinNode join = node.getJoinClauses()[i];
                joinClauses[i] = String.format("%1$s.%2$s=%3$s.%4$s", node.getLhsAlias(), join.getLeftSide().getFieldName(), node.getRhsAlias(), join.getRightSide().getFieldName());
            }
            buffer.append(StringUtils.join(" AND ", joinClauses));
        } else {
            for (int j = 0; j < node.getJoinClauses().length; ++j) {
                joinClauses[j] = node.getJoinClauses()[j].getLeftSide().getFieldName();
            }
            if (joinClauses.length != 0) {
                buffer.append(' ').append(StringUtils.commaSeparate(joinClauses));
            }
        }
        buffer.append(" [").append(node.getRhs().accept(this)).append(']');
        return buffer.toString();
    }

    @Override
    public String visit(MStatsCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("| mstats ");
        buffer.append(StringUtils.commaSeparate(this.asSplArray(node.getAggregates(), true)));
        if (node.getPredicate() != null) {
            buffer.append(" WHERE ");
            buffer.append(node.getPredicate().getNode().accept(this));
        }
        if (node.getByFields() != null && !node.getByFields().isEmpty()) {
            IExpression[] byFields = node.getByFields().toArray(new IGroupBy[0]);
            if (byFields[byFields.length - 1] instanceof BinNode) {
                IExpression[] byFieldsMinusTime = Arrays.copyOf(byFields, byFields.length - 1);
                if (byFieldsMinusTime.length > 0) {
                    buffer.append(" BY ");
                    buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(byFieldsMinusTime), true)));
                }
                BinNode timeSpanNode = (BinNode)byFields[byFields.length - 1];
                buffer.append(" span=").append(timeSpanNode.getSpan());
            } else {
                buffer.append(" BY ");
                buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(byFields), true)));
            }
        }
        return buffer.toString();
    }

    @Override
    public String visit(McatalogCommand node) {
        BooleanNode append;
        StringBuilder buffer = new StringBuilder();
        buffer.append("| mcatalog ");
        BooleanNode prestats = node.getPrestatsNode();
        if (prestats != null) {
            buffer.append("prestats=").append(prestats).append(' ');
        }
        if ((append = node.getAppendNode()) != null) {
            buffer.append("append=").append(append).append(' ');
        }
        buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getAggregateNodes()), true)));
        if (node.getPredicate() != null) {
            buffer.append(" WHERE ");
            buffer.append(node.getPredicate().getNode().accept(this));
        }
        if (node.getByFields() != null && !node.getByFields().isEmpty()) {
            buffer.append(" GROUP BY ");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getByFields().toArray(new IGroupBy[0])), true)));
        }
        return buffer.toString();
    }

    @Override
    public String visit(RegexCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this)).append(" | regex ");
        if (!node.getFieldName().equals("_raw") || node.getOperator() == Operator.NOT_EQUAL) {
            buffer.append(node.getFieldName());
            buffer.append(node.getOperator().toSplOperator());
        }
        buffer.append('\"');
        buffer.append(node.getRegex());
        buffer.append('\"');
        return buffer.toString();
    }

    @Override
    public String visit(RenameCommand node) {
        RenameNode[] nodes = node.getRenames();
        Object[] renames = new String[nodes.length];
        if (nodes.length == 0) {
            return node.getSources()[0].accept(this);
        }
        for (int i = 0; i < nodes.length; ++i) {
            renames[i] = nodes[i].accept(this);
        }
        return String.format("%1$s | rename %2$s", node.getSources()[0].accept(this), StringUtils.commaSeparate(renames));
    }

    @Override
    public String visit(ReverseCommand node) {
        return node.getSource().accept(this) + " | reverse";
    }

    @Override
    public String visit(RexCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this)).append(" | rex");
        if (node.getField() != null && !"_raw".equals(node.getField().getFieldName())) {
            buffer.append(" field=").append(node.getField().accept(this));
        }
        if (node.isSedMode()) {
            buffer.append(" mode=sed ");
            buffer.append('\"').append(node.getSedExpression()).append('\"');
        } else {
            if (node.getOffsetField() != null) {
                buffer.append(" offset_field=").append(node.getOffsetField().accept(this));
            }
            if (node.getMaxMatch() != 1) {
                buffer.append(" max_match=").append(node.getMaxMatch());
            }
            buffer.append(" \"").append(node.getRegexExpression().replace("\"", "\\\"")).append('\"');
        }
        return buffer.toString();
    }

    @Override
    public String visit(SavedsearchCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("| savedsearch ");
        buffer.append(SplFormatter.applyQuotingIfContainsWhitespace(node.savedsearchName()));
        if (node.isNosubstitutions()) {
            buffer.append(' ').append("nosubstitutions=true");
        }
        if (node.getReplacements().length > 0) {
            for (int i = 0; i < node.getReplacements().length; ++i) {
                buffer.append(' ');
                buffer.append(node.getReplacements()[i].getPlaceholder());
                buffer.append(Operator.EQUAL.toSplOperator());
                buffer.append('\"').append(node.getReplacements()[i].getReplacement()).append('\"');
            }
        }
        return buffer.toString();
    }

    @Override
    public String visit(SearchCommand node) {
        StringBuilder buffer = new StringBuilder();
        if (node.getSources().length > 0) {
            buffer.append(node.getSource().accept(this)).append(" | search ");
        } else {
            buffer.append("search ");
        }
        String predicate = node.getPredicate().getNode().accept(this);
        if (predicate.isEmpty()) {
            predicate = node.getPredicate() instanceof SearchOrNode ? "NOT()" : "*";
        }
        buffer.append(predicate);
        return buffer.toString();
    }

    @Override
    public String visit(SelfJoinCommand node) {
        StringBuilder buffer = new StringBuilder();
        Object[] joinClauses = new String[node.getJoinClauses().length];
        buffer.append(node.getLhs().accept(this));
        buffer.append(" | selfjoin");
        SplFormatter.visitSelfJoinCommandOptions(buffer, node);
        for (int j = 0; j < node.getJoinClauses().length; ++j) {
            joinClauses[j] = node.getJoinClauses()[j].getLeftSide().getFieldName();
        }
        if (joinClauses.length != 0) {
            buffer.append(' ').append(StringUtils.commaSeparate(joinClauses));
        }
        return buffer.toString();
    }

    @Override
    public String visit(SendalertCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | sendalert ").append(node.getName().getValue());
        if (node.getResultsLink() != null && !node.getResultsLink().getValue().isEmpty()) {
            buffer.append(" results_link=").append(node.getResultsLink().getValue());
        }
        if (node.getResultsPath() != null && !node.getResultsPath().getValue().isEmpty()) {
            buffer.append(" results_path=").append(node.getResultsPath().getValue());
        }
        if (node.getParams().length > 0) {
            buffer.append(' ');
            Object[] params = new String[node.getParams().length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = node.getParams()[i].toString();
            }
            buffer.append(StringUtils.join(" ", params));
        }
        return buffer.toString();
    }

    @Override
    public String visit(ApplyCommand node) {
        return node.getSource().accept(this) + " | apply " + node.getSPL();
    }

    @Override
    public String visit(FitCommand node) {
        return node.getSource().accept(this) + " | fit " + node.getSPL();
    }

    @Override
    public String visit(ParamNode node) {
        StringBuilder buffer = new StringBuilder();
        String paramName = node.getParamName();
        String paramValue = node.getParamValue();
        buffer.append("param.").append(paramName).append(" = ").append(paramValue);
        return buffer.toString();
    }

    @Override
    public String visit(SortCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | sort ");
        if (node.getCount() != 10000) {
            buffer.append(node.getCount()).append(' ');
        }
        Object[] clauses = new String[node.getBy().length];
        for (int i = 0; i < clauses.length; ++i) {
            IOrdering ordering = node.getBy()[i];
            clauses[i] = ordering instanceof SortNode ? this.visit((SortNode)ordering) : ordering.toString();
        }
        buffer.append(StringUtils.commaSeparate(clauses));
        return buffer.toString();
    }

    @Override
    public String visit(StatsCommand node) {
        StringBuilder buffer = new StringBuilder();
        List<IGroupBy> byFields = node.getByFields();
        buffer.append(node.getSources()[0].accept(this));
        if (node.isPrestatsMode()) {
            buffer.append(" | prestats");
        } else {
            buffer.append(" | stats");
        }
        BooleanNode bNode = node.getAllnum();
        StringNode sNode = node.getDelim();
        NumberNode nNode = node.getPartitions();
        if (bNode != null) {
            buffer.append(" allnum=").append(bNode);
        }
        if (sNode != null) {
            buffer.append(" delim=").append(sNode.accept(this));
        }
        if (nNode != null && !node.isPrestatsMode()) {
            buffer.append(" partitions=").append(nNode);
        }
        buffer.append(' ');
        buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getAggregates().toArray(new IExpression[0])), true)));
        if (!byFields.isEmpty()) {
            buffer.append(" BY ");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(byFields.toArray(new IGroupBy[0])), true)));
        }
        return buffer.toString();
    }

    @Override
    public String visit(JobPartitionerCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | jobpartition ");
        buffer.append("partitionName=").append(node.getJobPartitionName());
        if (node.getByFields() != null) {
            buffer.append(" key=");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getByFields()), true)));
        }
        if (node.isInternalJob()) {
            buffer.append(" internal=t");
        } else {
            buffer.append(" internal=f");
        }
        return buffer.toString();
    }

    @Override
    public String visit(TableCommand node) {
        return String.format("%1$s | table %2$s", node.getSources()[0].accept(this), StringUtils.commaSeparate(this.asSplArray(node.getFields(), true)));
    }

    @Override
    public String visit(TailCommand node) {
        return node.getSource().accept(this) + " | tail " + node.getLimit();
    }

    @Override
    public String visit(TStatsCommand node) {
        StringBuilder buffer = new StringBuilder();
        if (node.isAppend()) {
            buffer.append(node.getSource().accept(this));
            buffer.append(" | tstats");
            buffer.append(" append=t");
        } else {
            buffer.append("| tstats");
        }
        buffer.append(SplFormatter.visit(node.getOptions()));
        buffer.append(' ').append(StringUtils.commaSeparate(this.asSplArray(node.getAggregates(), true)));
        if (node.getNamespace() != null && !node.getNamespace().isEmpty()) {
            buffer.append(" FROM ");
            buffer.append(node.getNamespace());
        }
        if (node.getPredicate() != null) {
            buffer.append(" WHERE ");
            buffer.append(node.getPredicate().getNode().accept(this));
        }
        if (node.getByFields() != null && node.getByFields().length > 0) {
            buffer.append(" BY ");
            buffer.append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getByFields()), true)));
        }
        return buffer.toString();
    }

    public static String visit(TStatsOptions options) {
        StringBuilder buffer = new StringBuilder();
        if (options.isPrestats()) {
            buffer.append(" prestats=t");
        }
        if (options.isLocal()) {
            buffer.append(" local=t");
        }
        if (options.isSummariesonly()) {
            buffer.append(" summariesonly=t");
        }
        if (options.isAllowOldSummaries()) {
            buffer.append(" allow_old_summaries=t");
        }
        if (options.getChunksize() != 10000000) {
            buffer.append(" chunksize=").append(options.getChunksize());
        }
        return buffer.toString();
    }

    @Override
    public String visit(UnionCommand node) {
        return "| union " + SplFormatter.visitUnionOptions(node) + StringUtils.join(" ", this.formatSubsearches(node.getSources()));
    }

    @Override
    public String visit(WhereCommand node) {
        if (node.getPredicate() == null) {
            return String.format("%1$s | where", node.getSources()[0].accept(this));
        }
        return String.format("%1$s | where %2$s", node.getSources()[0].accept(this), node.getPredicate().getNode().accept(this));
    }

    @Override
    public String visit(AggregateNode node) {
        FieldNode aggAndField = node.getEvalFunc() == null ? AggregateNode.createDefaultAsField(node.getFunction(), node.getField()) : AggregateNode.createDefaultAsField(node.getFunction(), node.getEvalFunc());
        String aggAndFieldName = aggAndField.getFieldName().replaceAll("'", "\"");
        if (node.hasDefaultAsName()) {
            return aggAndFieldName;
        }
        return String.format("%1$s AS %2$s", aggAndFieldName, this.visit(node.getAsField(), true));
    }

    @Override
    public String visit(EvalAggregateNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getEvalFunc().accept(this));
        if (!node.hasDefaultAsName()) {
            sb.append(" AS ").append(node.getAsName());
        }
        return sb.toString();
    }

    @Override
    public String visit(PercentageAggregateNode node) {
        FieldNode aggAndField = PercentageAggregateNode.createDefaultAsField(node.getFunction(), node.getField(), node.getPercentage());
        String aggAndFieldName = aggAndField.getFieldName().replaceAll("'", "\"");
        if (node.hasDefaultAsName()) {
            return aggAndFieldName;
        }
        return String.format("%1$s AS %2$s", aggAndFieldName, this.visit(node.getAsField(), true));
    }

    @Override
    public String visit(SparklineAggregateNode node) {
        FieldNode aggAndField = SparklineAggregateNode.createDefaultAsField(node.getSparklineAggregateFunction(), node.getField(), node.getTimeSpan().getValue());
        String aggAndFieldName = aggAndField.getFieldName().replaceAll("'", "\"");
        if (node.hasDefaultAsName()) {
            return aggAndFieldName;
        }
        return String.format("%1$s AS %2$s", aggAndFieldName, this.visit(node.getAsField(), true));
    }

    @Override
    public String visit(Conditional node) {
        String pipeline = node.getPipeline().accept(this);
        if (node.getFilter() == null) {
            return String.format("se [%1$s ]", pipeline);
        }
        return String.format("if (%1$s) [%2$s ]", node.getFilter().getNode().accept(this), pipeline);
    }

    @Override
    public String visit(FieldNode node) {
        String retVal = node.getFieldName();
        if (StringUtils.isQuoteNeeded(retVal) && !retVal.startsWith("'")) {
            retVal = '\'' + retVal + '\'';
        }
        if (node.getSource() != null) {
            retVal = node.getSource().getNode().accept(this) + '.' + retVal;
        }
        return retVal;
    }

    private String visit(FieldNode node, boolean quoteSingleToDouble) {
        String retVal = this.visit(node);
        return quoteSingleToDouble ? retVal.replaceAll("^'|'$", "\"") : retVal;
    }

    @Override
    public String visit(NavigationNode node) {
        String retVal = node.getName();
        if (node.getSource() != null) {
            retVal = node.getSource().getNode().accept(this) + '.' + retVal;
        }
        return retVal;
    }

    @Override
    public String visit(BinNode node) {
        StringBuilder buffer = new StringBuilder();
        FieldNode binField = node.getField();
        BinOptionsNode binOptions = node.getBinOptions();
        if (this.useSpanOptionMode) {
            buffer.append(this.visit(binField, true));
            if (binOptions != null) {
                buffer.append(' ').append(binOptions.accept(this));
            }
        } else if (binOptions != null && binOptions.getSpan() != null) {
            buffer.append("span(").append(this.visit(binField, true)).append(", ").append(binOptions.getSpan()).append(')');
        } else {
            throw new UnsupportedOperationException("The full bin function is not supported yet. Currently only span function is supported.");
        }
        return buffer.toString();
    }

    @Override
    public String visit(BinOptionsNode node) {
        StringBuilder sb = new StringBuilder();
        if (node.getSpan() != null) {
            sb.append("span=").append(node.getSpan()).append(' ');
        }
        if (node.getMinspan() != null) {
            sb.append("minspan=").append(node.getMinspan()).append(' ');
        }
        if (node.getBins() != null) {
            sb.append("bins=").append(node.getBins()).append(' ');
        }
        if (node.getStart() != null) {
            sb.append("start=").append(node.getStart()).append(' ');
        }
        if (node.getEnd() != null) {
            sb.append("end=").append(node.getEnd());
        }
        return sb.toString().trim();
    }

    @Override
    public String visit(TableColumnOptionsNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)super.visit(node));
        if (node.getUseNull() != null) {
            sb.append(" usenull=").append(node.getUseNull());
        }
        if (node.getUseOther() != null) {
            sb.append(" useother=").append(node.getUseOther());
        }
        if (node.getNullStr() != null) {
            sb.append(" nullstr=").append(node.getNullStr().accept(this));
        }
        if (node.getOtherStr() != null) {
            sb.append(" otherstr=").append(node.getOtherStr().accept(this));
        }
        return sb.toString().trim();
    }

    @Override
    public String visit(TimeSpanNode node) {
        StringBuilder sb = new StringBuilder();
        if (node.getSpanLength() != null) {
            sb.append(node.getSpanLength());
        } else if (node.getSnapToTime() != null) {
            sb.append(node.getSnapToTime());
        } else {
            throw new IllegalStateException("Invalid TimeSpanNode: either spanLength or snapToTime needs to be set.");
        }
        return sb.toString();
    }

    @Override
    public String visit(LogSpanNode node) {
        StringBuilder sb = new StringBuilder();
        if (node.getCoefficient() != null) {
            sb.append(node.getCoefficient());
        }
        sb.append("log");
        if (node.getBase() != null) {
            sb.append(node.getBase());
        }
        return sb.toString();
    }

    @Override
    public String visit(TimechartCommand node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getSources()[0].accept(this));
        sb.append(" | ").append(node.getCommandName());
        if (node.getAgg() != null) {
            sb.append(" agg=").append(node.getAgg().accept(this));
        }
        if (node.getCont() != null) {
            sb.append(" cont=").append(node.getCont().getValue());
        }
        if (node.getFixedRange() != null) {
            sb.append(" fixedrange=").append(node.getFixedRange().getValue());
        }
        if (node.getFormat() != null) {
            sb.append(" format=").append(node.getFormat().accept(this));
        }
        if (node.getLimit() != null) {
            sb.append(" limit=").append(node.getLimit().accept(this));
        }
        if (node.getPartial() != null) {
            sb.append(" partial=").append(node.getPartial().getValue());
        }
        if (node.getSep() != null) {
            sb.append(" sep=").append(node.getSep().accept(this));
        }
        if (node.getBinOptions() != null) {
            sb.append(' ').append(node.getBinOptions().accept(this));
        }
        sb.append(' ').append(StringUtils.commaSeparate(this.asSplArray(SplFormatter.asTypeNodeArray(node.getAggregates()), true)));
        if (node.getSplitBy() != null) {
            sb.append(" BY ");
            if (node.getSplitBy() instanceof BinNode) {
                sb.append(((BinNode)node.getSplitBy()).accept(this));
            } else if (node.getSplitBy() instanceof FieldNode) {
                sb.append(((FieldNode)node.getSplitBy()).accept(this));
            } else {
                throw new IllegalStateException("A group by field must be either a BinNode or a FieldNode.");
            }
        }
        return sb.toString();
    }

    @Override
    public String visit(BooleanNode node) {
        return node + "()";
    }

    @Override
    public String visit(NullNode node) {
        return node.toString();
    }

    @Override
    public String visit(NumberNode node) {
        return node.toString();
    }

    @Override
    public String visit(SortNode node) {
        String result = this.visit(node.getField(), true);
        if (node.getFieldType() != FieldType.AUTO) {
            result = node.getFieldType().toString().toLowerCase() + '(' + result + ')';
        }
        if (node.getSortOrder() == SortOrder.DESC) {
            result = '-' + result;
        }
        return result;
    }

    @Override
    public String visit(StringNode node) {
        return '\"' + node.getValue().replace("\"", "\\\"") + '\"';
    }

    @Override
    public String visit(ComparisonNode node) {
        return String.format("%1$s%2$s%3$s", node.getLhs().accept(this), node.getOperator().toSplOperator(), node.getRhs().accept(this));
    }

    @Override
    public String visit(AddInfoCommand node) {
        return node.getSources()[0].accept(this) + node;
    }

    @Override
    public String visit(RdOutCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSources()[0].accept(this));
        buffer.append(" | rdout");
        buffer.append(" partition_method=\"").append(node.getPartitionMethodAsString());
        buffer.append('\"');
        switch (node.getPartitionMethod()) {
            case Hash: {
                if (node.getPartitionkeys() == null) break;
                buffer.append(" hash_keys=\"").append(node.getPartitionkeys());
                buffer.append('\"');
                break;
            }
            case VirtualPartitioning: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        buffer.append(" workers=\"").append(node.getDFSWorkersAsString());
        buffer.append('\"');
        return buffer.toString();
    }

    @Override
    public String visit(RdInCommand node) {
        StringBuilder buffer = new StringBuilder();
        if (!node.isSourceEmpty()) {
            buffer.append(node.getSources()[0].accept(this));
        }
        buffer.append(node);
        return buffer.toString();
    }

    @Override
    public String visit(NoOpCommand node) {
        return node.getSources()[0].accept(this) + node;
    }

    @Override
    public String visit(RenameNode node) {
        return this.visit(node.getField(), true) + " AS " + this.visit(node.getNewField(), true);
    }

    @Override
    public String visit(BooleanFunctionNode node) {
        switch (node.getFunctionName()) {
            case "any": 
            case "all": {
                if (node.getArguments().size() != 2) {
                    throw new IllegalStateException("The any and all functions both have exactly two arguments.");
                }
                return this.printCollectionFunction(node.getFunctionName(), (NavigationNode)node.getArguments().get(0), (IPredicate)((Object)node.getArguments().get(1)));
            }
            case "not": 
            case "NOT": {
                return this.visit((NotNode)node);
            }
        }
        return this.visit((FunctionNode)node);
    }

    @Override
    public String visit(FunctionNode node) {
        Object[] parameters = new String[node.getArguments().size()];
        for (int i = 0; i < parameters.length; ++i) {
            ComparisonNode cn;
            TypeNode arg = node.getArguments().get(i);
            if (arg instanceof ComparisonNode && (cn = (ComparisonNode)arg).getOperator() == Operator.EQUAL) {
                arg = new ComparisonNode(Operator.EQUAL_EQUAL, cn.getLhs(), cn.getRhs());
            }
            parameters[i] = arg.accept(this);
            if (!(arg instanceof FunctionNode)) continue;
            FunctionNode fnode = (FunctionNode)arg;
            if (!node.isShorthand() || !fnode.isShorthand() || node.getFunctionName().equals(fnode.getFunctionName())) continue;
            parameters[i] = '(' + (String)parameters[i] + ')';
        }
        if (node.isShorthand()) {
            return (String)parameters[0] + node.getFunctionName() + (String)parameters[1];
        }
        String paramsPart = StringUtils.commaSeparate(parameters);
        if ("searchmatch".equals(node.getFunctionName()) && !paramsPart.startsWith("\"") && !paramsPart.endsWith("\"")) {
            return String.format("%1$s(\"%2$s\")", node.getFunctionName(), paramsPart);
        }
        return String.format("%1$s(%2$s)", node.getFunctionName(), paramsPart);
    }

    @Override
    public String visit(OrNode node) {
        return StringUtils.join(" OR ", this.asSplArray(node.getArguments(), false));
    }

    @Override
    public String visit(XorNode node) {
        return StringUtils.join(" XOR ", this.asSplArray(node.getArguments(), false));
    }

    @Override
    public String visit(AndNode node) {
        return StringUtils.join(" AND ", this.asSplArray(node.getArguments(), false));
    }

    @Override
    public String visit(NotNode node) {
        return node.getFunctionName() + " (" + node.getArguments().get(0).accept(this) + ')';
    }

    @Override
    public String visit(InNode node) {
        List<TypeNode> args = node.getArguments();
        if (args.isEmpty()) {
            throw new RuntimeException();
        }
        return this.visitChild(args.get(0)) + ' ' + node.getFunctionName() + " (" + StringUtils.commaSeparate(this.asSplArray(args.subList(1, args.size()), false)) + ')';
    }

    @Override
    public String visit(MultiValueNode node) {
        Object[] mv = node.getValue();
        if (mv == null) {
            throw new RuntimeException();
        }
        if (mv.length == 0) {
            return "mvrange(0, 0.1, \"1s\")";
        }
        if (mv.length == 1) {
            String s = mv[0].getValue();
            if (s.startsWith("0")) {
                return "ltrim(ltrim(ltrim(ltrim(mvzip(mvrange(0, .1), mvappend(" + StringUtils.applyQuoting(s, true) + ", \"\")), \"0\"), \".\"), \"0\"), \",\")";
            }
            return "ltrim(ltrim(ltrim(mvzip(mvrange(0, .1), mvappend(" + StringUtils.applyQuoting(s, true) + ", \"\"), \"\"), \"0\"), \".\"), \"0\")";
        }
        return "mvappend(" + StringUtils.commaSeparate(mv, true) + ')';
    }

    @Override
    public String visit(MvexpandCommand node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.getSource().accept(this));
        buffer.append(" | mvexpand");
        NumberNode limit = node.getLimit();
        if (limit != null) {
            buffer.append(" limit=").append(limit.getValue());
        }
        buffer.append(' ');
        buffer.append(this.visit(node.getFieldNode(), true));
        return buffer.toString();
    }

    private String formatSubsearch(CommandNode node) {
        if (this.enableDatasetSerializationShorthand && node instanceof FromCommand && ((FromCommand)node).supportsShorthand()) {
            return node.getDataset().toString();
        }
        return '[' + node.accept(this) + ']';
    }

    private String[] formatSubsearches(CommandNode[] nodes) {
        String[] formatter = new String[nodes.length];
        for (int i = 0; i < formatter.length; ++i) {
            formatter[i] = this.formatSubsearch(nodes[i]);
        }
        return formatter;
    }

    private String[] asSplArray(IOrdering[] args) {
        String[] values = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = args[i].getTypeNode().accept(this);
        }
        return values;
    }

    private String[] asSplArray(TypeNode[] args, boolean fieldQuoteConversion) {
        return this.asSplArray(Arrays.asList(args), fieldQuoteConversion);
    }

    protected <T extends TypeNode> String[] asSplArray(List<T> args, boolean fieldQuoteConversion) {
        String[] values = new String[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            values[i] = args.get(i) instanceof FieldNode ? this.visit((FieldNode)args.get(i), fieldQuoteConversion) : this.visitChild((TypeNode)args.get(i));
        }
        return values;
    }

    private static TypeNode[] asTypeNodeArray(IExpression[] expressions) {
        TypeNode[] nodes = new TypeNode[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            nodes[i] = expressions[i].getTypeNode();
        }
        return nodes;
    }

    private static String applyQuotingIfContainsWhitespace(String spl) {
        if (spl.contains(" ")) {
            return SplFormatter.applyQuoting(spl, true);
        }
        return spl;
    }

    private static String applyQuoting(String spl, boolean quote) {
        boolean isPreQuoted;
        boolean bl = isPreQuoted = !spl.isEmpty() && spl.charAt(0) == '\"' && spl.charAt(spl.length() - 1) == '\"';
        if (quote && !isPreQuoted) {
            return '\"' + spl + '\"';
        }
        return spl;
    }

    private static String applyModifier(String spl, SearchModifier modifier) {
        switch (modifier) {
            case NONE: {
                return spl;
            }
            case CASE: {
                return "CASE(" + spl + ')';
            }
            case TERM: {
                return "TERM(" + spl + ')';
            }
        }
        throw new RuntimeException("Unexpected SearchModifier found.");
    }

    private static String applyNegation(String spl, boolean negate) {
        return negate ? "NOT " + spl : spl;
    }

    private String visitChild(TypeNode node) {
        if (node instanceof SearchAndNode || node instanceof SearchOrNode || node instanceof SearchXorNode | node instanceof AndNode || node instanceof OrNode || node instanceof XorNode) {
            return String.format("(%1$s)", node.accept(this));
        }
        return node.accept(this);
    }

    private static void visitJoinCommandOptions(StringBuilder buffer, JoinCommand node) {
        if (node.getJoinType() != JoinType.INNER) {
            buffer.append(" type=").append(node.getJoinType().toString().toLowerCase());
        }
        if (!node.isUsetime()) {
            buffer.append(" usetime=").append(node.isUsetime() ? "true" : "false");
        }
        if (!node.isEarlier()) {
            buffer.append(" earlier=").append(node.isEarlier() ? "true" : "false");
        }
        if (!node.isOverwrite()) {
            buffer.append(" overwrite=").append(node.isOverwrite() ? "true" : "false");
        }
        if (node.getMax() != 1) {
            buffer.append(" max=").append(node.getMax());
        }
    }

    private static void visitSelfJoinCommandOptions(StringBuilder buffer, SelfJoinCommand node) {
        if (!node.isOverwrite()) {
            buffer.append(" overwrite=").append(node.isOverwrite() ? "true" : "false");
        }
        if (node.getMax() != 1) {
            buffer.append(" max=").append(node.getMax());
        }
        if (node.isKeepsingle()) {
            buffer.append(" keepsingle=").append(node.isKeepsingle() ? "true" : "false");
        }
    }

    private String printCollectionFunction(String functionName, NavigationNode source, IPredicate predicate) {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(source);
        Objects.requireNonNull(predicate);
        return source.accept(this) + '.' + functionName + '[' + predicate.getNode().accept(this) + ']';
    }

    private static String visitUnionOptions(UnionCommand node) {
        Map.Entry<String, String>[] options = node.getOptions();
        if (options == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> option : options) {
            buffer.append(option.getKey()).append(Operator.EQUAL.toSplOperator()).append(option.getValue()).append(' ');
        }
        return buffer.toString();
    }
}

