/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.visitors.CommandRebuilder;

public class ValidationVisitor
extends CommandRebuilder {
    private final boolean isRemote;
    private final StringBuilder sb;
    private boolean shouldShortCircuit;
    private boolean startPaused;

    public ValidationVisitor(boolean isRemote) {
        this.isRemote = isRemote;
        this.sb = new StringBuilder();
        this.shouldShortCircuit = false;
    }

    public String getMessageForSRI() {
        return this.sb.toString();
    }

    public boolean getShouldShortCircuit() {
        return this.shouldShortCircuit;
    }

    public boolean isStartPaused() {
        return this.startPaused;
    }

    @Override
    public CommandNode visit(CommandNode node) {
        CommandNode[] currentNode = node.getSources();
        if (node.getSources().length != 0) {
            for (int i = 0; i < currentNode.length; ++i) {
                this.visit(currentNode[i]);
            }
        }
        CommandNode processedNode = this.validateNode(node);
        return processedNode;
    }

    private CommandNode validateNode(CommandNode node) {
        if (node.isCommandExternal()) {
            this.sb.append("DEBUG:" + node.getCommandName() + " is an external transformer and it be run in a soft container.");
        }
        if (!this.isRemote && node.requiresPrevStreaming()) {
            throw new UnsupportedOperationException(node.getCommandName() + " cannot be invoked after the non-streaming command");
        }
        if (node.getSources().length == 0 && node.shouldShortCircuit()) {
            this.shouldShortCircuit = true;
        }
        if (node.startPaused()) {
            this.startPaused = true;
        }
        return node;
    }
}

