/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.util.IndexingUtils;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.NormalizingVisitor;
import java.util.List;

public class WhereToSearchConverter
extends NodeVisitor<ISearchPredicate> {
    private final NormalizingVisitor normalizer = new NormalizingVisitor();

    @Override
    public ISearchPredicate visit(Node node) {
        return null;
    }

    @Override
    public ISearchPredicate visit(BooleanFunctionNode node) {
        if (node.getFunctionName().equals("searchmatch")) {
            return (ISearchPredicate)((Object)node.getArguments().get(0));
        }
        return null;
    }

    @Override
    public ISearchPredicate visit(AndNode node) {
        List<TypeNode> args = node.getArguments();
        ISearchPredicate andNode = new SearchAndNode(new ISearchPredicate[0]);
        for (int i = 0; i < args.size(); ++i) {
            IPredicate predicate = args.get(i).accept(this);
            if (predicate == null) {
                return null;
            }
            andNode = (ISearchPredicate)andNode.and(predicate);
        }
        return andNode;
    }

    @Override
    public ISearchPredicate visit(OrNode node) {
        List<TypeNode> args = node.getArguments();
        ISearchPredicate orNode = new SearchOrNode(new ISearchPredicate[0]);
        for (int i = 0; i < args.size(); ++i) {
            IPredicate predicate = args.get(i).accept(this);
            if (predicate == null) {
                return null;
            }
            orNode = (ISearchPredicate)orNode.or(predicate);
        }
        return orNode;
    }

    @Override
    public ISearchPredicate visit(XorNode node) {
        List<TypeNode> args = node.getArguments();
        ISearchPredicate xorNode = new SearchXorNode(new ISearchPredicate[0]);
        for (int i = 0; i < args.size(); ++i) {
            IPredicate predicate = args.get(i).accept(this);
            if (predicate == null) {
                return null;
            }
            xorNode = (ISearchPredicate)xorNode.xor(predicate);
        }
        return xorNode;
    }

    @Override
    public ISearchPredicate visit(NotNode node) {
        List<TypeNode> args = node.getArguments();
        return new SearchNotNode(args.get(0).accept(this));
    }

    @Override
    public ISearchPredicate visit(ComparisonNode node) {
        if ((node = (ComparisonNode)node.accept(this.normalizer)).getLhs() instanceof FieldNode) {
            if (node.getRhs() instanceof StringNode) {
                return new SearchComparisonNode(node.getOperator(), (FieldNode)node.getLhs(), node.getRhs(), false, false, true, IndexingUtils.isIndexedField(((FieldNode)node.getLhs()).getFieldName()), SearchModifier.CASE);
            }
            if (node.getRhs() instanceof NumberNode) {
                return new SearchComparisonNode(node.getOperator(), (FieldNode)node.getLhs(), node.getRhs(), false, false, false, IndexingUtils.isIndexedField(((FieldNode)node.getLhs()).getFieldName()), SearchModifier.NONE);
            }
        }
        return null;
    }
}

